/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lambda.model.VpcConfigResponse;

public class VpcConfigResponseJsonMarshaller {
    private static VpcConfigResponseJsonMarshaller instance;

    public void marshall(VpcConfigResponse vpcConfigResponse, StructuredJsonGenerator jsonGenerator) {
        if (vpcConfigResponse == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList securityGroupIdsList;
            jsonGenerator.writeStartObject();
            SdkInternalList subnetIdsList = (SdkInternalList)vpcConfigResponse.getSubnetIds();
            if (!subnetIdsList.isEmpty() || !subnetIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("SubnetIds");
                jsonGenerator.writeStartArray();
                for (String subnetIdsListValue : subnetIdsList) {
                    if (subnetIdsListValue == null) continue;
                    jsonGenerator.writeValue(subnetIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(securityGroupIdsList = (SdkInternalList)vpcConfigResponse.getSecurityGroupIds()).isEmpty() || !securityGroupIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("SecurityGroupIds");
                jsonGenerator.writeStartArray();
                for (String securityGroupIdsListValue : securityGroupIdsList) {
                    if (securityGroupIdsListValue == null) continue;
                    jsonGenerator.writeValue(securityGroupIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (vpcConfigResponse.getVpcId() != null) {
                jsonGenerator.writeFieldName("VpcId").writeValue(vpcConfigResponse.getVpcId());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static VpcConfigResponseJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new VpcConfigResponseJsonMarshaller();
        }
        return instance;
    }
}

