/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.CopySnapshotRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CopySnapshotRequestMarshaller
implements Marshaller<Request<CopySnapshotRequest>, CopySnapshotRequest> {
    @Override
    public Request<CopySnapshotRequest> marshall(CopySnapshotRequest copySnapshotRequest) {
        if (copySnapshotRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CopySnapshotRequest> request = new DefaultRequest<CopySnapshotRequest>(copySnapshotRequest, "AmazonEC2");
        request.addParameter("Action", "CopySnapshot");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (copySnapshotRequest.getSourceRegion() != null) {
            request.addParameter("SourceRegion", StringUtils.fromString(copySnapshotRequest.getSourceRegion()));
        }
        if (copySnapshotRequest.getSourceSnapshotId() != null) {
            request.addParameter("SourceSnapshotId", StringUtils.fromString(copySnapshotRequest.getSourceSnapshotId()));
        }
        if (copySnapshotRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(copySnapshotRequest.getDescription()));
        }
        if (copySnapshotRequest.getDestinationRegion() != null) {
            request.addParameter("DestinationRegion", StringUtils.fromString(copySnapshotRequest.getDestinationRegion()));
        }
        if (copySnapshotRequest.getPresignedUrl() != null) {
            request.addParameter("PresignedUrl", StringUtils.fromString(copySnapshotRequest.getPresignedUrl()));
        }
        if (copySnapshotRequest.getEncrypted() != null) {
            request.addParameter("Encrypted", StringUtils.fromBoolean(copySnapshotRequest.getEncrypted()));
        }
        if (copySnapshotRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString(copySnapshotRequest.getKmsKeyId()));
        }
        return request;
    }
}

