/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverterFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.S3Link;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.util.DateUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;

@SdkInternalApi
final class StandardTypeConverters
extends DynamoDBTypeConverterFactory {
    private static final DynamoDBTypeConverterFactory FACTORY = new StandardTypeConverters();
    private static final Converter<BigDecimal, String> BigDecimalFromString = new Converter<BigDecimal, String>(){

        @Override
        public final BigDecimal convert(String o) {
            return new BigDecimal(o);
        }
    };
    private static final Converter<BigInteger, String> BigIntegerFromString = new Converter<BigInteger, String>(){

        @Override
        public final BigInteger convert(String o) {
            return new BigInteger(o);
        }
    };
    private static final Converter<Boolean, String> BooleanFromString = new Converter<Boolean, String>(){
        private final Pattern N0 = Pattern.compile("(?i)[N0]");
        private final Pattern Y1 = Pattern.compile("(?i)[Y1]");

        @Override
        public final Boolean convert(String o) {
            return this.N0.matcher(o).matches() ? Boolean.FALSE : (this.Y1.matcher(o).matches() ? Boolean.TRUE : Boolean.valueOf(o));
        }
    };
    private static final Converter<Byte, Number> ByteFromNumber = new Converter<Byte, Number>(){

        @Override
        public final Byte convert(Number o) {
            return o.byteValue();
        }
    };
    private static final Converter<Byte, String> ByteFromString = new Converter<Byte, String>(){

        @Override
        public final Byte convert(String o) {
            return Byte.valueOf(o);
        }
    };
    private static final Converter<byte[], ByteBuffer> ByteArrayFromByteBuffer = new Converter<byte[], ByteBuffer>(){

        @Override
        public final byte[] convert(ByteBuffer o) {
            if (o.hasArray()) {
                return o.array();
            }
            byte[] value = new byte[o.remaining()];
            o.get(value);
            return value;
        }
    };
    private static final Converter<byte[], String> ByteArrayFromString = new Converter<byte[], String>(){
        private final Charset UTF8 = Charset.forName("UTF-8");

        @Override
        public final byte[] convert(String o) {
            return o.getBytes(this.UTF8);
        }
    };
    private static final Converter<ByteBuffer, byte[]> ByteBufferFromByteArray = new Converter<ByteBuffer, byte[]>(){

        @Override
        public final ByteBuffer convert(byte[] o) {
            return ByteBuffer.wrap(o);
        }
    };
    private static final Converter<ByteBuffer, UUID> ByteBufferFromUuid = new Converter<ByteBuffer, UUID>(){

        @Override
        public final ByteBuffer convert(UUID o) {
            ByteBuffer value = ByteBuffer.allocate(16);
            value.putLong(o.getMostSignificantBits()).putLong(o.getLeastSignificantBits());
            value.position(0);
            return value;
        }
    };
    private static final Converter<Calendar, Date> CalendarFromDate = new Converter<Calendar, Date>(){

        @Override
        public final Calendar convert(Date o) {
            Calendar value = Calendar.getInstance();
            value.setTime(o);
            return value;
        }
    };
    private static final Converter<Character, String> CharacterFromString = new Converter<Character, String>(){

        @Override
        public final Character convert(String o) {
            return Character.valueOf(o.charAt(0));
        }
    };
    private static final Converter<Currency, String> CurrencyFromString = new Converter<Currency, String>(){

        @Override
        public final Currency convert(String o) {
            return Currency.getInstance(o);
        }
    };
    private static final Converter<Date, Calendar> DateFromCalendar = new Converter<Date, Calendar>(){

        @Override
        public final Date convert(Calendar o) {
            return o.getTime();
        }
    };
    private static final Converter<Date, Long> DateFromLong = new Converter<Date, Long>(){

        @Override
        public final Date convert(Long o) {
            return new Date(o);
        }
    };
    private static final Converter<Date, String> DateFromString = new Converter<Date, String>(){

        @Override
        public final Date convert(String o) {
            return DateUtils.parseISO8601Date(o);
        }
    };
    private static final Converter<Double, Number> DoubleFromNumber = new Converter<Double, Number>(){

        @Override
        public final Double convert(Number o) {
            return o.doubleValue();
        }
    };
    private static final Converter<Double, String> DoubleFromString = new Converter<Double, String>(){

        @Override
        public final Double convert(String o) {
            return Double.valueOf(o);
        }
    };
    private static final Converter<Float, Number> FloatFromNumber = new Converter<Float, Number>(){

        @Override
        public final Float convert(Number o) {
            return Float.valueOf(o.floatValue());
        }
    };
    private static final Converter<Float, String> FloatFromString = new Converter<Float, String>(){

        @Override
        public final Float convert(String o) {
            return Float.valueOf(o);
        }
    };
    private static final Converter<Integer, Number> IntegerFromNumber = new Converter<Integer, Number>(){

        @Override
        public final Integer convert(Number o) {
            return o.intValue();
        }
    };
    private static final Converter<Integer, String> IntegerFromString = new Converter<Integer, String>(){

        @Override
        public final Integer convert(String o) {
            return Integer.valueOf(o);
        }
    };
    private static final Converter<Locale, String> LocaleFromString = new Converter<Locale, String>(){

        @Override
        public final Locale convert(String o) {
            String[] value = o.split("-", 3);
            if (value.length == 3) {
                return new Locale(value[0], value[1], value[2]);
            }
            if (value.length == 2) {
                return new Locale(value[0], value[1]);
            }
            return new Locale(value[0]);
        }
    };
    private static final Converter<Long, Date> LongFromDate = new Converter<Long, Date>(){

        @Override
        public final Long convert(Date o) {
            return o.getTime();
        }
    };
    private static final Converter<Long, Number> LongFromNumber = new Converter<Long, Number>(){

        @Override
        public final Long convert(Number o) {
            return o.longValue();
        }
    };
    private static final Converter<Long, String> LongFromString = new Converter<Long, String>(){

        @Override
        public final Long convert(String o) {
            return Long.valueOf(o);
        }
    };
    private static final Converter<Short, Number> ShortFromNumber = new Converter<Short, Number>(){

        @Override
        public final Short convert(Number o) {
            return o.shortValue();
        }
    };
    private static final Converter<Short, String> ShortFromString = new Converter<Short, String>(){

        @Override
        public final Short convert(String o) {
            return Short.valueOf(o);
        }
    };
    private static final Converter<String, Boolean> StringFromBoolean = new Converter<String, Boolean>(){

        @Override
        public final String convert(Boolean o) {
            return Boolean.TRUE.equals(o) ? "1" : "0";
        }
    };
    private static final Converter<String, byte[]> StringFromByteArray = new Converter<String, byte[]>(){
        private final Charset UTF8 = Charset.forName("UTF-8");

        @Override
        public final String convert(byte[] o) {
            return new String(o, this.UTF8);
        }
    };
    private static final Converter<String, Date> StringFromDate = new Converter<String, Date>(){

        @Override
        public final String convert(Date o) {
            return DateUtils.formatISO8601Date(o);
        }
    };
    private static final Converter<String, Enum> StringFromEnum = new Converter<String, Enum>(){

        @Override
        public final String convert(Enum o) {
            return o.name();
        }
    };
    private static final Converter<String, Locale> StringFromLocale = new Converter<String, Locale>(){

        @Override
        public final String convert(Locale o) {
            StringBuilder value = new StringBuilder(o.getLanguage());
            if (!o.getCountry().isEmpty() || !o.getVariant().isEmpty()) {
                value.append("-").append(o.getCountry());
            }
            if (!o.getVariant().isEmpty()) {
                value.append("-").append(o.getVariant());
            }
            return value.toString();
        }
    };
    private static final Converter<String, TimeZone> StringFromTimeZone = new Converter<String, TimeZone>(){

        @Override
        public final String convert(TimeZone o) {
            return o.getID();
        }
    };
    private static final Converter<String, Object> StringFromObject = new Converter<String, Object>(){

        @Override
        public final String convert(Object o) {
            return o.toString();
        }
    };
    private static final Converter<TimeZone, String> TimeZoneFromString = new Converter<TimeZone, String>(){

        @Override
        public final TimeZone convert(String o) {
            return TimeZone.getTimeZone(o);
        }
    };
    private static final Converter<URL, String> UrlFromString = new Converter<URL, String>(){

        @Override
        public final URL convert(String o) {
            try {
                return new URL(o);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("malformed URL", e);
            }
        }
    };
    private static final Converter<UUID, ByteBuffer> UuidFromByteBuffer = new Converter<UUID, ByteBuffer>(){

        @Override
        public final UUID convert(ByteBuffer o) {
            return new UUID(o.getLong(), o.getLong());
        }
    };
    private static final Converter<UUID, String> UuidFromString = new Converter<UUID, String>(){

        @Override
        public final UUID convert(String o) {
            return UUID.fromString(o);
        }
    };
    private static final Converter<Object, Object> ObjectFromObject = new Converter<Object, Object>(){

        @Override
        public final Object convert(Object o) {
            return o;
        }
    };

    StandardTypeConverters() {
    }

    static DynamoDBTypeConverterFactory factory() {
        return FACTORY;
    }

    @Override
    public <S, T> DynamoDBTypeConverter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
        Scalar source = Scalar.of(sourceType);
        Scalar target = Scalar.of(targetType);
        final Converter sourceFromTarget = source.getConverter(sourceType, target.type());
        final Converter targetFromSource = target.getConverter(targetType, source.type());
        return new DynamoDBTypeConverter<S, T>(){

            @Override
            public final S convert(T o) {
                return sourceFromTarget.convert(o);
            }

            @Override
            public final T unconvert(S o) {
                return targetFromSource.convert(o);
            }
        };
    }

    static <S, T, U> DynamoDBTypeConverter<S, U> join(final DynamoDBTypeConverter<S, T> source, final DynamoDBTypeConverter<T, U> target) {
        return new DynamoDBTypeConverter<S, U>(){

            @Override
            public final S convert(U o) {
                Object object = o == null ? null : (Object)target.convert(o);
                return object == null ? null : (Object)source.convert(object);
            }

            @Override
            public final U unconvert(S o) {
                Object object = o == null ? null : (Object)source.unconvert(o);
                return object == null ? null : (Object)target.unconvert(object);
            }
        };
    }

    static /* synthetic */ Converter access$000() {
        return BigDecimalFromString;
    }

    static /* synthetic */ Converter access$300() {
        return BigIntegerFromString;
    }

    static /* synthetic */ Converter access$400() {
        return BooleanFromString;
    }

    static /* synthetic */ Converter access$500() {
        return ByteFromString;
    }

    static /* synthetic */ Converter access$600() {
        return ByteFromNumber;
    }

    static /* synthetic */ Converter access$700() {
        return ByteArrayFromString;
    }

    static /* synthetic */ Converter access$800() {
        return ByteArrayFromByteBuffer;
    }

    static /* synthetic */ Converter access$900() {
        return ByteBufferFromUuid;
    }

    static /* synthetic */ Converter access$1000() {
        return ByteBufferFromByteArray;
    }

    static /* synthetic */ Converter access$1100() {
        return DateFromString;
    }

    static /* synthetic */ Converter access$1200() {
        return CalendarFromDate;
    }

    static /* synthetic */ Converter access$1300() {
        return CharacterFromString;
    }

    static /* synthetic */ Converter access$1400() {
        return CurrencyFromString;
    }

    static /* synthetic */ Converter access$1500() {
        return DateFromLong;
    }

    static /* synthetic */ Converter access$1600() {
        return DateFromCalendar;
    }

    static /* synthetic */ Converter access$1700() {
        return DoubleFromString;
    }

    static /* synthetic */ Converter access$1800() {
        return DoubleFromNumber;
    }

    static /* synthetic */ Converter access$1900() {
        return FloatFromString;
    }

    static /* synthetic */ Converter access$2000() {
        return FloatFromNumber;
    }

    static /* synthetic */ Converter access$2100() {
        return IntegerFromString;
    }

    static /* synthetic */ Converter access$2200() {
        return IntegerFromNumber;
    }

    static /* synthetic */ Converter access$2300() {
        return LocaleFromString;
    }

    static /* synthetic */ Converter access$2400() {
        return LongFromString;
    }

    static /* synthetic */ Converter access$2500() {
        return LongFromNumber;
    }

    static /* synthetic */ Converter access$2600() {
        return LongFromDate;
    }

    static /* synthetic */ Converter access$2700() {
        return ShortFromString;
    }

    static /* synthetic */ Converter access$2800() {
        return ShortFromNumber;
    }

    static /* synthetic */ Converter access$2900() {
        return StringFromObject;
    }

    static /* synthetic */ Converter access$3000() {
        return StringFromTimeZone;
    }

    static /* synthetic */ Converter access$3100() {
        return StringFromLocale;
    }

    static /* synthetic */ Converter access$3200() {
        return StringFromEnum;
    }

    static /* synthetic */ Converter access$3300() {
        return StringFromDate;
    }

    static /* synthetic */ Converter access$3400() {
        return StringFromByteArray;
    }

    static /* synthetic */ Converter access$3500() {
        return StringFromBoolean;
    }

    static /* synthetic */ Converter access$3600() {
        return TimeZoneFromString;
    }

    static /* synthetic */ Converter access$3700() {
        return UrlFromString;
    }

    static /* synthetic */ Converter access$3800() {
        return UuidFromString;
    }

    static /* synthetic */ Converter access$3900() {
        return UuidFromByteBuffer;
    }

    private static final class EnumFromString<S extends Enum<S>>
    extends Converter<S, String> {
        private final Class<S> sourceType;

        private EnumFromString(Class<S> sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final S convert(String o) {
            return Enum.valueOf(this.sourceType, o);
        }
    }

    static abstract class Converter<S, T> {
        Converter() {
        }

        final <U> Converter<S, U> join(final Converter<T, U> target) {
            final Converter source = this;
            return new Converter<S, U>(){

                @Override
                public S convert(U o) {
                    return source.convert(target.convert(o));
                }
            };
        }

        public abstract S convert(T var1);
    }

    static final class Vector {
        Vector() {
        }

        static final class SET {
            SET() {
            }

            static <S, T> DynamoDBTypeConverter<List<S>, Collection<T>> join(final DynamoDBTypeConverter<S, T> target) {
                return new DynamoDBTypeConverter<List<S>, Collection<T>>(){

                    @Override
                    public List<S> convert(Collection<T> o) {
                        return LIST.convert(o, target);
                    }

                    @Override
                    public Collection<T> unconvert(List<S> o) {
                        return SET.unconvert(o, target);
                    }
                };
            }

            static <S, T> Set<T> unconvert(Collection<S> o, DynamoDBTypeConverter<S, T> scalar) {
                LinkedHashSet<T> vector = new LinkedHashSet<T>();
                for (S s : o) {
                    if (vector.add(scalar.unconvert(s))) continue;
                    throw new DynamoDBMappingException("duplicate value (" + s + ")");
                }
                return vector;
            }

            static boolean is(Class<?> sourceType) {
                return Set.class.isAssignableFrom(sourceType);
            }
        }

        static final class MAP {
            MAP() {
            }

            static <K, S, T> DynamoDBTypeConverter<Map<K, S>, Map<K, T>> join(final DynamoDBTypeConverter<S, T> scalar) {
                return new DynamoDBTypeConverter<Map<K, S>, Map<K, T>>(){

                    @Override
                    public final Map<K, S> convert(Map<K, T> o) {
                        return MAP.convert(o, scalar);
                    }

                    @Override
                    public final Map<K, T> unconvert(Map<K, S> o) {
                        return MAP.unconvert(o, scalar);
                    }
                };
            }

            static <K, S, T> Map<K, S> convert(Map<K, T> o, DynamoDBTypeConverter<S, T> scalar) {
                LinkedHashMap<K, S> vector = new LinkedHashMap<K, S>();
                for (Map.Entry<K, T> t : o.entrySet()) {
                    vector.put(t.getKey(), scalar.convert(t.getValue()));
                }
                return vector;
            }

            static <K, S, T> Map<K, T> unconvert(Map<K, S> o, DynamoDBTypeConverter<S, T> scalar) {
                LinkedHashMap<K, T> vector = new LinkedHashMap<K, T>();
                for (Map.Entry<K, S> s : o.entrySet()) {
                    vector.put(s.getKey(), scalar.unconvert(s.getValue()));
                }
                return vector;
            }

            static boolean is(Class<?> sourceType) {
                return Map.class.isAssignableFrom(sourceType);
            }
        }

        static final class LIST {
            LIST() {
            }

            static <S, T> DynamoDBTypeConverter<List<S>, List<T>> join(final DynamoDBTypeConverter<S, T> scalar) {
                return new DynamoDBTypeConverter<List<S>, List<T>>(){

                    @Override
                    public final List<S> convert(List<T> o) {
                        return LIST.convert(o, scalar);
                    }

                    @Override
                    public final List<T> unconvert(List<S> o) {
                        return LIST.unconvert(o, scalar);
                    }
                };
            }

            static <S, T> List<S> convert(Collection<T> o, DynamoDBTypeConverter<S, T> scalar) {
                ArrayList<S> vector = new ArrayList<S>(o.size());
                for (T t : o) {
                    vector.add(scalar.convert(t));
                }
                return vector;
            }

            static <S, T> List<T> unconvert(Collection<S> o, DynamoDBTypeConverter<S, T> scalar) {
                ArrayList<T> vector = new ArrayList<T>(o.size());
                for (S s : o) {
                    vector.add(scalar.unconvert(s));
                }
                return vector;
            }

            static boolean is(Class<?> sourceType) {
                return List.class.isAssignableFrom(sourceType);
            }
        }
    }

    static enum Scalar {
        BIG_DECIMAL(ScalarAttributeType.N, BigDecimal.class, null, ConverterMap.access$200(new ConverterMap<S>(), String.class, StandardTypeConverters.access$000())),
        BIG_INTEGER(ScalarAttributeType.N, BigInteger.class, null, ConverterMap.access$200(new ConverterMap<S>(), String.class, StandardTypeConverters.access$300())),
        BOOLEAN(ScalarAttributeType.N, Boolean.class, Boolean.TYPE, ConverterMap.access$200(new ConverterMap<S>(), String.class, StandardTypeConverters.access$400())),
        BYTE(ScalarAttributeType.N, Byte.class, Byte.TYPE, ConverterMap.access$200(ConverterMap.access$200(new ConverterMap<S>(), Number.class, StandardTypeConverters.access$600()), String.class, StandardTypeConverters.access$500())),
        BYTE_ARRAY(ScalarAttributeType.B, byte[].class, null, ConverterMap.access$200(ConverterMap.access$200(new ConverterMap<S>(), ByteBuffer.class, StandardTypeConverters.access$800()), String.class, StandardTypeConverters.access$700())),
        BYTE_BUFFER(ScalarAttributeType.B, ByteBuffer.class, null, ConverterMap.access$200(ConverterMap.access$200(ConverterMap.access$200(new ConverterMap<S>(), byte[].class, StandardTypeConverters.access$1000()), String.class, StandardTypeConverters.access$1000().join(StandardTypeConverters.access$700())), UUID.class, StandardTypeConverters.access$900())),
        CALENDAR(ScalarAttributeType.S, Calendar.class, null, ConverterMap.access$200(ConverterMap.access$200(new ConverterMap<S>(), Date.class, StandardTypeConverters.access$1200()), String.class, StandardTypeConverters.access$1200().join(StandardTypeConverters.access$1100()))),
        CHARACTER(ScalarAttributeType.S, Character.class, Character.TYPE, ConverterMap.access$200(new ConverterMap<S>(), String.class, StandardTypeConverters.access$1300())),
        CURRENCY(ScalarAttributeType.S, Currency.class, null, ConverterMap.access$200(new ConverterMap<S>(), String.class, StandardTypeConverters.access$1400())),
        DATE(ScalarAttributeType.S, Date.class, null, ConverterMap.access$200(ConverterMap.access$200(ConverterMap.access$200(new ConverterMap<S>(), Calendar.class, StandardTypeConverters.access$1600()), Long.class, StandardTypeConverters.access$1500()), String.class, StandardTypeConverters.access$1100())),
        DOUBLE(ScalarAttributeType.N, Double.class, Double.TYPE, ConverterMap.access$200(ConverterMap.access$200(new ConverterMap<S>(), Number.class, StandardTypeConverters.access$1800()), String.class, StandardTypeConverters.access$1700())),
        FLOAT(ScalarAttributeType.N, Float.class, Float.TYPE, ConverterMap.access$200(ConverterMap.access$200(new ConverterMap<S>(), Number.class, StandardTypeConverters.access$2000()), String.class, StandardTypeConverters.access$1900())),
        INTEGER(ScalarAttributeType.N, Integer.class, Integer.TYPE, ConverterMap.access$200(ConverterMap.access$200(new ConverterMap<S>(), Number.class, StandardTypeConverters.access$2200()), String.class, StandardTypeConverters.access$2100())),
        LOCALE(ScalarAttributeType.S, Locale.class, null, ConverterMap.access$200(new ConverterMap<S>(), String.class, StandardTypeConverters.access$2300())),
        LONG(ScalarAttributeType.N, Long.class, Long.TYPE, ConverterMap.access$200(ConverterMap.access$200(ConverterMap.access$200(new ConverterMap<S>(), Date.class, StandardTypeConverters.access$2600()), Number.class, StandardTypeConverters.access$2500()), String.class, StandardTypeConverters.access$2400())),
        S3_LINK(ScalarAttributeType.S, S3Link.class, null, new ConverterMap<S>()),
        SHORT(ScalarAttributeType.N, Short.class, Short.TYPE, ConverterMap.access$200(ConverterMap.access$200(new ConverterMap<S>(), Number.class, StandardTypeConverters.access$2800()), String.class, StandardTypeConverters.access$2700())),
        STRING(ScalarAttributeType.S, String.class, null, ConverterMap.access$200(ConverterMap.access$200(ConverterMap.access$200(ConverterMap.access$200(ConverterMap.access$200(ConverterMap.access$200(ConverterMap.access$200(ConverterMap.access$200(ConverterMap.access$200(new ConverterMap<S>(), Boolean.class, StandardTypeConverters.access$3500()), byte[].class, StandardTypeConverters.access$3400()), ByteBuffer.class, StandardTypeConverters.access$3400().join(StandardTypeConverters.access$800())), Calendar.class, StandardTypeConverters.access$3300().join(StandardTypeConverters.access$1600())), Date.class, StandardTypeConverters.access$3300()), Enum.class, StandardTypeConverters.access$3200()), Locale.class, StandardTypeConverters.access$3100()), TimeZone.class, StandardTypeConverters.access$3000()), Object.class, StandardTypeConverters.access$2900())),
        TIME_ZONE(ScalarAttributeType.S, TimeZone.class, null, ConverterMap.access$200(new ConverterMap<S>(), String.class, StandardTypeConverters.access$3600())),
        URL(ScalarAttributeType.S, URL.class, null, ConverterMap.access$200(new ConverterMap<S>(), String.class, StandardTypeConverters.access$3700())),
        UUID(ScalarAttributeType.S, UUID.class, null, ConverterMap.access$200(ConverterMap.access$200(new ConverterMap<S>(), ByteBuffer.class, StandardTypeConverters.access$3900()), String.class, StandardTypeConverters.access$3800())),
        DEFAULT(null, Object.class, null, new ConverterMap<S>());

        private final ScalarAttributeType scalarAttributeType;
        private final Class<?> type;
        private final Class<?> primitiveType;
        private final ConverterMap<Object> map;

        private Scalar(ScalarAttributeType scalarAttributeType, Class<?> type, Class<?> primitiveType, ConverterMap<?> map) {
            this.scalarAttributeType = scalarAttributeType;
            this.primitiveType = primitiveType;
            this.type = type;
            this.map = map;
        }

        final <S, T> Converter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
            if (this == DEFAULT && sourceType.isEnum() && STRING.is(targetType)) {
                return new EnumFromString(sourceType);
            }
            for (Map.Entry entry : this.map.entrySet()) {
                if (!((Class)entry.getKey()).isAssignableFrom(targetType)) continue;
                return (Converter)entry.getValue();
            }
            if (this.is(targetType)) {
                return ObjectFromObject;
            }
            throw new DynamoDBMappingException("type [" + targetType + "] is not supported; no conversion from " + sourceType);
        }

        final <S, T> S convert(T o) {
            return this.getConverter(this.type(), o.getClass()).convert(o);
        }

        final <S, T> DynamoDBTypeConverter<S, T> join(Class<T> targetType) {
            return StandardTypeConverters.factory().getConverter(this.type(), targetType);
        }

        final boolean is(ScalarAttributeType scalarAttributeType) {
            return this.scalarAttributeType == scalarAttributeType;
        }

        final boolean is(Class<?> sourceType) {
            if (sourceType.isPrimitive()) {
                return this.primitiveType != null && this.primitiveType.isAssignableFrom(sourceType);
            }
            return this.type.isAssignableFrom(sourceType);
        }

        final <S> Class<S> type() {
            return this.type;
        }

        static Scalar of(Class<?> sourceType) {
            for (Scalar scalar : Scalar.values()) {
                if (!scalar.is(sourceType)) continue;
                return scalar;
            }
            return DEFAULT;
        }

        private static final class ConverterMap<S>
        extends LinkedHashMap<Class<?>, Converter<S, ?>> {
            private static final long serialVersionUID = -1L;

            private ConverterMap() {
            }

            private <T> ConverterMap<S> with(Class<T> targetType, Converter<S, T> converter) {
                this.put(targetType, converter);
                return this;
            }

            static /* synthetic */ ConverterMap access$200(ConverterMap x0, Class x1, Converter x2) {
                return x0.with(x1, x2);
            }
        }
    }
}

