/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchema;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchemas;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperModelFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.S3Link;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardBeanProperties;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardConverterRules;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@SdkInternalApi
final class StandardModelFactories {
    StandardModelFactories() {
    }

    static final DynamoDBMapperModelFactory.Factory of(S3Link.Factory s3Links) {
        return new ConversionSchemaFactory(s3Links);
    }

    private static final class FieldModelBuilder<T, V>
    extends DynamoDBMapperFieldModel.Builder<T, V> {
        private FieldModelBuilder(StandardBeanProperties.Bean<T, V> bean, StandardConverterRules.Rule<V> rule) {
            super(bean);
            this.withAttributeType(rule.getAttributeType());
            this.with(rule.newConverter(bean.type()));
            this.with(bean.reflect());
        }
    }

    private static final class TableModelBuilder<T>
    extends DynamoDBMapperTableModel.Builder<T> {
        private TableModelBuilder(StandardBeanProperties.Beans<T> beans, StandardConverterRules.RuleFactory rules) {
            super(beans);
            for (StandardBeanProperties.Bean<T, Object> bean : beans.map().values()) {
                this.with(new FieldModelBuilder(bean, rules.getRule(bean)).build());
            }
        }
    }

    private static final class StandardModelFactory
    implements DynamoDBMapperModelFactory {
        private final ConcurrentMap<Class<?>, DynamoDBMapperTableModel<?>> cache = new ConcurrentHashMap();
        private final StandardConverterRules.RuleFactory rules;

        private StandardModelFactory(StandardConverterRules.RuleFactory rules) {
            this.rules = rules;
        }

        @Override
        public <T> DynamoDBMapperTableModel<T> getTableModel(Class<T> targetType) {
            if (!this.cache.containsKey(targetType)) {
                StandardBeanProperties.Beans<T> beans = StandardBeanProperties.of(targetType);
                this.cache.putIfAbsent(targetType, new TableModelBuilder(beans, this.rules).build());
            }
            return (DynamoDBMapperTableModel)this.cache.get(targetType);
        }
    }

    private static final class ConversionSchemaFactory
    implements DynamoDBMapperModelFactory.Factory {
        private final ConcurrentMap<ConversionSchema, DynamoDBMapperModelFactory> cache = new ConcurrentHashMap<ConversionSchema, DynamoDBMapperModelFactory>();
        private final S3Link.Factory s3Links;

        private ConversionSchemaFactory(S3Link.Factory s3Links) {
            this.s3Links = s3Links;
        }

        @Override
        public DynamoDBMapperModelFactory getModelFactory(DynamoDBMapperConfig config) {
            ConversionSchema schema = config.getConversionSchema();
            if (!this.cache.containsKey(schema)) {
                StandardConverterRules.RuleFactory rules = StandardConverterRules.of(config, this.s3Links, this);
                rules = new ConversionSchemas.ItemConverterRuleFactory(config, this.s3Links.getS3ClientCache(), rules);
                this.cache.putIfAbsent(schema, new StandardModelFactory(rules));
            }
            return (DynamoDBMapperModelFactory)this.cache.get(schema);
        }
    }
}

