/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

@SdkInternalApi
final class StandardAttributeTypes {
    StandardAttributeTypes() {
    }

    static final void copy(AttributeValue from, AttributeValue into) {
        for (AttributeType attribute : AttributeType.values()) {
            attribute.copy(from, into);
        }
    }

    static enum AttributeType implements DynamoDBTypeConverter<AttributeValue, Object>
    {
        BOOL((DynamoDBMapperFieldModel.Reflect)new DynamoDBMapperFieldModel.Reflect<AttributeValue, Boolean>(){

            @Override
            public final void set(AttributeValue o, Boolean value) {
                o.setBOOL(value);
            }

            @Override
            public final Boolean get(AttributeValue o) {
                return o.getBOOL();
            }
        }){

            @Override
            public final Object unconvert(AttributeValue o) {
                if (o.getBOOL() == null && o.getN() != null) {
                    return StandardTypeConverters.Scalar.BOOLEAN.convert(o.getN());
                }
                return super.unconvert(o);
            }
        }
        ,
        S((DynamoDBMapperFieldModel.Reflect)new DynamoDBMapperFieldModel.Reflect<AttributeValue, String>(){

            @Override
            public final void set(AttributeValue o, String value) {
                o.setS(value);
            }

            @Override
            public final String get(AttributeValue o) {
                return o.getS();
            }
        }){

            @Override
            public final AttributeValue convert(Object o) {
                return ((String)o).length() == 0 ? null : super.convert(o);
            }
        }
        ,
        N(new DynamoDBMapperFieldModel.Reflect<AttributeValue, String>(){

            @Override
            public final void set(AttributeValue o, String value) {
                o.setN(value);
            }

            @Override
            public final String get(AttributeValue o) {
                return o.getN();
            }
        }),
        B(new DynamoDBMapperFieldModel.Reflect<AttributeValue, ByteBuffer>(){

            @Override
            public final void set(AttributeValue o, ByteBuffer value) {
                o.setB(value);
            }

            @Override
            public final ByteBuffer get(AttributeValue o) {
                return o.getB();
            }
        }),
        SS(new DynamoDBMapperFieldModel.Reflect<AttributeValue, List<String>>(){

            @Override
            public final void set(AttributeValue o, List<String> value) {
                o.setSS(value);
            }

            @Override
            public final List<String> get(AttributeValue o) {
                return o.getSS();
            }
        }),
        NS(new DynamoDBMapperFieldModel.Reflect<AttributeValue, List<String>>(){

            @Override
            public final void set(AttributeValue o, List<String> value) {
                o.setNS(value);
            }

            @Override
            public final List<String> get(AttributeValue o) {
                return o.getNS();
            }
        }),
        BS(new DynamoDBMapperFieldModel.Reflect<AttributeValue, List<ByteBuffer>>(){

            @Override
            public final void set(AttributeValue o, List<ByteBuffer> value) {
                o.setBS(value);
            }

            @Override
            public final List<ByteBuffer> get(AttributeValue o) {
                return o.getBS();
            }
        }),
        L(new DynamoDBMapperFieldModel.Reflect<AttributeValue, List<AttributeValue>>(){

            @Override
            public final void set(AttributeValue o, List<AttributeValue> value) {
                o.setL(value);
            }

            @Override
            public final List<AttributeValue> get(AttributeValue o) {
                return o.getL();
            }
        }),
        M(new DynamoDBMapperFieldModel.Reflect<AttributeValue, Map<String, AttributeValue>>(){

            @Override
            public final void set(AttributeValue o, Map<String, AttributeValue> value) {
                o.setM(value);
            }

            @Override
            public final Map<String, AttributeValue> get(AttributeValue o) {
                return o.getM();
            }
        }),
        NULL((DynamoDBMapperFieldModel.Reflect)new DynamoDBMapperFieldModel.Reflect<AttributeValue, Boolean>(){

            @Override
            public final void set(AttributeValue o, Boolean value) {
                o.setNULL(value);
            }

            @Override
            public final Boolean get(AttributeValue o) {
                return o.getNULL();
            }
        }){

            @Override
            final <S, V> DynamoDBTypeConverter<AttributeValue, V> join(DynamoDBTypeConverter<S, V> target) {
                final DynamoDBTypeConverter<S, V> converter = target;
                return new DynamoDBTypeConverter<AttributeValue, V>(){

                    @Override
                    public final AttributeValue convert(V o) {
                        return o == null ? new AttributeValue().withNULL(true) : (AttributeValue)converter.convert(o);
                    }

                    @Override
                    public final V unconvert(AttributeValue o) {
                        return converter.unconvert(o);
                    }
                };
            }
        };

        private final ScalarAttributeType scalarAttributeType = this.name().matches("[BNS]S?") ? ScalarAttributeType.valueOf(this.name().substring(0, 1)) : null;
        private final DynamoDBMapperFieldModel.DynamoDBAttributeType attributeType = DynamoDBMapperFieldModel.DynamoDBAttributeType.valueOf(this.name());
        private final DynamoDBMapperFieldModel.Reflect<AttributeValue, Object> reflect;

        private AttributeType(DynamoDBMapperFieldModel.Reflect<AttributeValue, ?> reflect) {
            this.reflect = reflect;
        }

        <S, V> DynamoDBTypeConverter<AttributeValue, V> join(DynamoDBTypeConverter<S, V> target) {
            return StandardTypeConverters.join(this, target);
        }

        final DynamoDBMapperFieldModel.DynamoDBAttributeType attributeType() {
            return this.attributeType;
        }

        final ScalarAttributeType scalarAttributeType() {
            return this.scalarAttributeType;
        }

        @Override
        public AttributeValue convert(Object o) {
            AttributeValue value = new AttributeValue();
            this.reflect.set(value, o);
            return value;
        }

        @Override
        public Object unconvert(AttributeValue o) {
            Object value = this.reflect.get(o);
            if (value == null && o.isNULL() == null) {
                throw new DynamoDBMappingException("expected " + this.name() + " in value " + o);
            }
            return value;
        }

        final void copy(AttributeValue from, AttributeValue into) {
            this.reflect.set(into, this.reflect.get(from));
        }
    }
}

