/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.DetachLoadBalancerTargetGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DetachLoadBalancerTargetGroupsRequestMarshaller
implements Marshaller<Request<DetachLoadBalancerTargetGroupsRequest>, DetachLoadBalancerTargetGroupsRequest> {
    @Override
    public Request<DetachLoadBalancerTargetGroupsRequest> marshall(DetachLoadBalancerTargetGroupsRequest detachLoadBalancerTargetGroupsRequest) {
        SdkInternalList targetGroupARNsList;
        if (detachLoadBalancerTargetGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DetachLoadBalancerTargetGroupsRequest> request = new DefaultRequest<DetachLoadBalancerTargetGroupsRequest>(detachLoadBalancerTargetGroupsRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DetachLoadBalancerTargetGroups");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachLoadBalancerTargetGroupsRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(detachLoadBalancerTargetGroupsRequest.getAutoScalingGroupName()));
        }
        if (!(targetGroupARNsList = (SdkInternalList)detachLoadBalancerTargetGroupsRequest.getTargetGroupARNs()).isEmpty() || !targetGroupARNsList.isAutoConstruct()) {
            int targetGroupARNsListIndex = 1;
            for (String targetGroupARNsListValue : targetGroupARNsList) {
                if (targetGroupARNsListValue != null) {
                    request.addParameter("TargetGroupARNs.member." + targetGroupARNsListIndex, StringUtils.fromString(targetGroupARNsListValue));
                }
                ++targetGroupARNsListIndex;
            }
        }
        return request;
    }
}

