/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationdiscovery.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.applicationdiscovery.model.Filter;
import java.util.List;

public class FilterJsonMarshaller {
    private static FilterJsonMarshaller instance;

    public void marshall(Filter filter, StructuredJsonGenerator jsonGenerator) {
        if (filter == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> valuesList;
            jsonGenerator.writeStartObject();
            if (filter.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(filter.getName());
            }
            if ((valuesList = filter.getValues()) != null) {
                jsonGenerator.writeFieldName("values");
                jsonGenerator.writeStartArray();
                for (String valuesListValue : valuesList) {
                    if (valuesListValue == null) continue;
                    jsonGenerator.writeValue(valuesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (filter.getCondition() != null) {
                jsonGenerator.writeFieldName("condition").writeValue(filter.getCondition());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FilterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FilterJsonMarshaller();
        }
        return instance;
    }
}

