/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetUsagePlansRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetUsagePlansRequestMarshaller
implements Marshaller<Request<GetUsagePlansRequest>, GetUsagePlansRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetUsagePlansRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetUsagePlansRequest> marshall(GetUsagePlansRequest getUsagePlansRequest) {
        if (getUsagePlansRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetUsagePlansRequest> request = new DefaultRequest<GetUsagePlansRequest>(getUsagePlansRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/usageplans";
        request.setResourcePath(uriResourcePath);
        if (getUsagePlansRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString(getUsagePlansRequest.getPosition()));
        }
        if (getUsagePlansRequest.getKeyId() != null) {
            request.addParameter("keyId", StringUtils.fromString(getUsagePlansRequest.getKeyId()));
        }
        if (getUsagePlansRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger(getUsagePlansRequest.getLimit()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

