/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.kinesisanalytics.model.SourceSchema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DiscoverInputSchemaResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SourceSchema inputSchema;
    private List<List<String>> parsedInputRecords;
    private List<String> rawInputRecords;

    public void setInputSchema(SourceSchema inputSchema) {
        this.inputSchema = inputSchema;
    }

    public SourceSchema getInputSchema() {
        return this.inputSchema;
    }

    public DiscoverInputSchemaResult withInputSchema(SourceSchema inputSchema) {
        this.setInputSchema(inputSchema);
        return this;
    }

    public List<List<String>> getParsedInputRecords() {
        return this.parsedInputRecords;
    }

    public void setParsedInputRecords(Collection<List<String>> parsedInputRecords) {
        if (parsedInputRecords == null) {
            this.parsedInputRecords = null;
            return;
        }
        this.parsedInputRecords = new ArrayList<List<String>>(parsedInputRecords);
    }

    public DiscoverInputSchemaResult withParsedInputRecords(List<String> ... parsedInputRecords) {
        if (this.parsedInputRecords == null) {
            this.setParsedInputRecords(new ArrayList<List<String>>(parsedInputRecords.length));
        }
        for (List<String> ele : parsedInputRecords) {
            this.parsedInputRecords.add(ele);
        }
        return this;
    }

    public DiscoverInputSchemaResult withParsedInputRecords(Collection<List<String>> parsedInputRecords) {
        this.setParsedInputRecords(parsedInputRecords);
        return this;
    }

    public List<String> getRawInputRecords() {
        return this.rawInputRecords;
    }

    public void setRawInputRecords(Collection<String> rawInputRecords) {
        if (rawInputRecords == null) {
            this.rawInputRecords = null;
            return;
        }
        this.rawInputRecords = new ArrayList<String>(rawInputRecords);
    }

    public DiscoverInputSchemaResult withRawInputRecords(String ... rawInputRecords) {
        if (this.rawInputRecords == null) {
            this.setRawInputRecords(new ArrayList<String>(rawInputRecords.length));
        }
        for (String ele : rawInputRecords) {
            this.rawInputRecords.add(ele);
        }
        return this;
    }

    public DiscoverInputSchemaResult withRawInputRecords(Collection<String> rawInputRecords) {
        this.setRawInputRecords(rawInputRecords);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInputSchema() != null) {
            sb.append("InputSchema: " + this.getInputSchema() + ",");
        }
        if (this.getParsedInputRecords() != null) {
            sb.append("ParsedInputRecords: " + this.getParsedInputRecords() + ",");
        }
        if (this.getRawInputRecords() != null) {
            sb.append("RawInputRecords: " + this.getRawInputRecords());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInputSchemaResult)) {
            return false;
        }
        DiscoverInputSchemaResult other = (DiscoverInputSchemaResult)obj;
        if (other.getInputSchema() == null ^ this.getInputSchema() == null) {
            return false;
        }
        if (other.getInputSchema() != null && !other.getInputSchema().equals(this.getInputSchema())) {
            return false;
        }
        if (other.getParsedInputRecords() == null ^ this.getParsedInputRecords() == null) {
            return false;
        }
        if (other.getParsedInputRecords() != null && !other.getParsedInputRecords().equals(this.getParsedInputRecords())) {
            return false;
        }
        if (other.getRawInputRecords() == null ^ this.getRawInputRecords() == null) {
            return false;
        }
        return other.getRawInputRecords() == null || other.getRawInputRecords().equals(this.getRawInputRecords());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInputSchema() == null ? 0 : this.getInputSchema().hashCode());
        hashCode = 31 * hashCode + (this.getParsedInputRecords() == null ? 0 : this.getParsedInputRecords().hashCode());
        hashCode = 31 * hashCode + (this.getRawInputRecords() == null ? 0 : this.getRawInputRecords().hashCode());
        return hashCode;
    }

    public DiscoverInputSchemaResult clone() {
        try {
            return (DiscoverInputSchemaResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

