/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.inspector.model.AssessmentRun;
import com.amazonaws.services.inspector.model.FailedItemDetails;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DescribeAssessmentRunsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<AssessmentRun> assessmentRuns;
    private Map<String, FailedItemDetails> failedItems;

    public List<AssessmentRun> getAssessmentRuns() {
        return this.assessmentRuns;
    }

    public void setAssessmentRuns(Collection<AssessmentRun> assessmentRuns) {
        if (assessmentRuns == null) {
            this.assessmentRuns = null;
            return;
        }
        this.assessmentRuns = new ArrayList<AssessmentRun>(assessmentRuns);
    }

    public DescribeAssessmentRunsResult withAssessmentRuns(AssessmentRun ... assessmentRuns) {
        if (this.assessmentRuns == null) {
            this.setAssessmentRuns(new ArrayList<AssessmentRun>(assessmentRuns.length));
        }
        for (AssessmentRun ele : assessmentRuns) {
            this.assessmentRuns.add(ele);
        }
        return this;
    }

    public DescribeAssessmentRunsResult withAssessmentRuns(Collection<AssessmentRun> assessmentRuns) {
        this.setAssessmentRuns(assessmentRuns);
        return this;
    }

    public Map<String, FailedItemDetails> getFailedItems() {
        return this.failedItems;
    }

    public void setFailedItems(Map<String, FailedItemDetails> failedItems) {
        this.failedItems = failedItems;
    }

    public DescribeAssessmentRunsResult withFailedItems(Map<String, FailedItemDetails> failedItems) {
        this.setFailedItems(failedItems);
        return this;
    }

    public DescribeAssessmentRunsResult addFailedItemsEntry(String key, FailedItemDetails value) {
        if (null == this.failedItems) {
            this.failedItems = new HashMap<String, FailedItemDetails>();
        }
        if (this.failedItems.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.failedItems.put(key, value);
        return this;
    }

    public DescribeAssessmentRunsResult clearFailedItemsEntries() {
        this.failedItems = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssessmentRuns() != null) {
            sb.append("AssessmentRuns: " + this.getAssessmentRuns() + ",");
        }
        if (this.getFailedItems() != null) {
            sb.append("FailedItems: " + this.getFailedItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssessmentRunsResult)) {
            return false;
        }
        DescribeAssessmentRunsResult other = (DescribeAssessmentRunsResult)obj;
        if (other.getAssessmentRuns() == null ^ this.getAssessmentRuns() == null) {
            return false;
        }
        if (other.getAssessmentRuns() != null && !other.getAssessmentRuns().equals(this.getAssessmentRuns())) {
            return false;
        }
        if (other.getFailedItems() == null ^ this.getFailedItems() == null) {
            return false;
        }
        return other.getFailedItems() == null || other.getFailedItems().equals(this.getFailedItems());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssessmentRuns() == null ? 0 : this.getAssessmentRuns().hashCode());
        hashCode = 31 * hashCode + (this.getFailedItems() == null ? 0 : this.getFailedItems().hashCode());
        return hashCode;
    }

    public DescribeAssessmentRunsResult clone() {
        try {
            return (DescribeAssessmentRunsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

