/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.amazonaws.services.dynamodbv2.model.transform.DeleteRequestJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.PutRequestJsonMarshaller;

public class WriteRequestJsonMarshaller {
    private static WriteRequestJsonMarshaller instance;

    public void marshall(WriteRequest writeRequest, StructuredJsonGenerator jsonGenerator) {
        if (writeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (writeRequest.getPutRequest() != null) {
                jsonGenerator.writeFieldName("PutRequest");
                PutRequestJsonMarshaller.getInstance().marshall(writeRequest.getPutRequest(), jsonGenerator);
            }
            if (writeRequest.getDeleteRequest() != null) {
                jsonGenerator.writeFieldName("DeleteRequest");
                DeleteRequestJsonMarshaller.getInstance().marshall(writeRequest.getDeleteRequest(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static WriteRequestJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new WriteRequestJsonMarshaller();
        }
        return instance;
    }
}

