/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerator;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DynamoDBMapperFieldModel<T, V>
implements DynamoDBAutoGenerator<V>,
DynamoDBTypeConverter<AttributeValue, V> {
    private final DynamoDBTypeConverter<AttributeValue, V> attributeValueConverter;
    private final Properties<T, V> properties;
    private final Reflect<T, V> reflect;

    private DynamoDBMapperFieldModel(Builder<T, V> builder) {
        this.properties = new Properties.Immutable(builder);
        this.attributeValueConverter = ((Builder)builder).attributeValueConverter;
        this.reflect = ((Builder)builder).reflect;
    }

    final Id<T> id() {
        return this.properties.id();
    }

    @Deprecated
    public String getDynamoDBAttributeName() {
        return this.properties.attributeName();
    }

    @Deprecated
    public DynamoDBAttributeType getDynamoDBAttributeType() {
        return this.properties.attributeType();
    }

    public final String name() {
        return this.properties.attributeName();
    }

    public final V get(T object) {
        try {
            return this.reflect.get(object);
        }
        catch (RuntimeException e) {
            throw new DynamoDBMappingException(this.id().err("could not get", new Object[0]), e);
        }
    }

    public final void set(T object, V value) {
        try {
            this.reflect.set(object, value);
        }
        catch (RuntimeException e) {
            throw new DynamoDBMappingException(this.id().err("could not set", new Object[0]), e);
        }
    }

    @Override
    public final DynamoDBAutoGenerateStrategy getGenerateStrategy() {
        if (this.properties.autoGenerator() != null) {
            return this.properties.autoGenerator().getGenerateStrategy();
        }
        return null;
    }

    @Override
    public final V generate(V currentValue) {
        try {
            return this.properties.autoGenerator().generate(currentValue);
        }
        catch (RuntimeException e) {
            throw new DynamoDBMappingException(this.id().err("could not generate", new Object[0]), e);
        }
    }

    @Override
    public final AttributeValue convert(V object) {
        try {
            return this.attributeValueConverter.convert(object);
        }
        catch (RuntimeException e) {
            throw new DynamoDBMappingException(this.id().err("could not convert", new Object[0]), e);
        }
    }

    @Override
    public final V unconvert(AttributeValue object) {
        try {
            return this.attributeValueConverter.unconvert(object);
        }
        catch (RuntimeException e) {
            throw new DynamoDBMappingException(this.id().err("could not unconvert", new Object[0]), e);
        }
    }

    public final DynamoDBAttributeType attributeType() {
        return this.properties.attributeType();
    }

    public final KeyType keyType() {
        return this.properties.keyType();
    }

    public final boolean versioned() {
        return this.properties.versioned();
    }

    public final List<String> globalSecondaryIndexNames(KeyType keyType) {
        if (this.properties.globalSecondaryIndexNames().containsKey((Object)keyType)) {
            return this.properties.globalSecondaryIndexNames().get((Object)keyType);
        }
        return Collections.emptyList();
    }

    public final List<String> localSecondaryIndexNames() {
        return this.properties.localSecondaryIndexNames();
    }

    public final boolean anyKey(KeyType ... keyTypes) {
        for (KeyType k : keyTypes.length == 0 ? KeyType.values() : keyTypes) {
            if (this.keyType() == k) {
                return true;
            }
            if (!this.globalSecondaryIndexNames(k).isEmpty()) {
                return true;
            }
            if (KeyType.RANGE != k || this.localSecondaryIndexNames().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public final ExpectedAttributeValue expectedExists(V value) {
        return new ExpectedAttributeValue().withExists(true).withValue((AttributeValue)this.convert((Object)value));
    }

    public final ExpectedAttributeValue expectedNotExists() {
        return new ExpectedAttributeValue().withExists(false);
    }

    public final ExpectedAttributeValue expectedIfExists(V value) {
        return value == null ? this.expectedNotExists() : this.expectedExists(value);
    }

    public final Condition beginsWith(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.BEGINS_WITH).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition between(V lo, V hi) {
        return new Condition().withComparisonOperator(ComparisonOperator.BETWEEN).withAttributeValueList(new AttributeValue[]{this.convert((Object)lo), this.convert((Object)hi)});
    }

    public final Condition contains(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.CONTAINS).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition eq(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.EQ).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition ge(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.GE).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition gt(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.GT).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition in(Collection<V> values) {
        return new Condition().withComparisonOperator(ComparisonOperator.IN).withAttributeValueList(StandardTypeConverters.Vector.LIST.convert(values, this));
    }

    public final Condition in(V ... values) {
        return this.in((Collection<V>)Arrays.asList(values));
    }

    public final Condition isNull() {
        return new Condition().withComparisonOperator(ComparisonOperator.NULL);
    }

    public final Condition le(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.LE).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition lt(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.LT).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition ne(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.NE).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition notContains(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.NOT_CONTAINS).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition notNull() {
        return new Condition().withComparisonOperator(ComparisonOperator.NOT_NULL);
    }

    public final Condition betweenAny(V lo, V hi) {
        return lo == null ? (hi == null ? null : this.le(hi)) : (hi == null ? this.ge(lo) : (lo.equals(hi) ? this.eq(lo) : this.between(lo, hi)));
    }

    static interface Reflect<T, V> {
        public V get(T var1);

        public void set(T var1, V var2);
    }

    static interface Properties<T, V> {
        public Id<T> id();

        public Class<V> targetType();

        public String attributeName();

        public DynamoDBAttributeType attributeType();

        public KeyType keyType();

        public boolean versioned();

        public Map<KeyType, List<String>> globalSecondaryIndexNames();

        public List<String> localSecondaryIndexNames();

        public DynamoDBAutoGenerator<V> autoGenerator();

        public <S> DynamoDBTypeConverter<S, V> typeConverter();

        public static class Buildable<T, V>
        extends Immutable<T, V> {
            public Buildable(Properties<T, V> ... defaults) {
                super(defaults);
            }

            public final Buildable<T, V> withId(Id<T> id) {
                ((Immutable)this).id = id;
                return this;
            }

            public final Buildable<T, V> withTargetType(Class<V> targetType) {
                ((Immutable)this).targetType = targetType;
                return this;
            }

            public final Buildable<T, V> withAttributeName(String attributeName) {
                ((Immutable)this).attributeName = attributeName;
                return this;
            }

            public final Buildable<T, V> withAttributeType(DynamoDBAttributeType attributeType) {
                ((Immutable)this).attributeType = attributeType;
                return this;
            }

            public final Buildable<T, V> withKeyType(KeyType keyType) {
                ((Immutable)this).keyType = keyType;
                return this;
            }

            public final Buildable<T, V> withVersioned(boolean versioned) {
                ((Immutable)this).versioned = versioned;
                return this;
            }

            public final Buildable<T, V> withGlobalSecondaryIndexNames(Map<KeyType, List<String>> names) {
                ((Immutable)this).globalSecondaryIndexNames = names;
                return this;
            }

            public final Buildable<T, V> withLocalSecondaryIndexNames(List<String> names) {
                ((Immutable)this).localSecondaryIndexNames = names;
                return this;
            }

            public final Buildable<T, V> withAutoGenerator(DynamoDBAutoGenerator<V> autoGenerator) {
                ((Immutable)this).autoGenerator = autoGenerator;
                return this;
            }

            public final Buildable<T, V> withTypeConverter(DynamoDBTypeConverter<?, V> typeConverter) {
                ((Immutable)this).typeConverter = typeConverter;
                return this;
            }
        }

        public static class Immutable<T, V>
        implements Properties<T, V> {
            private static final Properties<Object, Object> EMPTY = new Immutable<Object, Object>(new Properties[0]);
            private Id<T> id;
            private Class<V> targetType;
            private String attributeName;
            private DynamoDBAttributeType attributeType;
            private KeyType keyType;
            private boolean versioned;
            private Map<KeyType, List<String>> globalSecondaryIndexNames = Collections.emptyMap();
            private List<String> localSecondaryIndexNames = Collections.emptyList();
            private DynamoDBAutoGenerator<V> autoGenerator;
            private DynamoDBTypeConverter<?, V> typeConverter;

            static final <T, V> Properties<T, V> empty() {
                return EMPTY;
            }

            public Immutable(Properties<T, V> ... defaults) {
                for (Properties<T, V> d : defaults) {
                    this.targetType = d.targetType();
                    this.attributeName = d.attributeName();
                    this.attributeType = d.attributeType();
                    this.keyType = d.keyType();
                    this.versioned = d.versioned();
                    this.globalSecondaryIndexNames = d.globalSecondaryIndexNames();
                    this.localSecondaryIndexNames = d.localSecondaryIndexNames();
                    this.autoGenerator = d.autoGenerator();
                    this.typeConverter = d.typeConverter();
                    this.id = d.id();
                }
            }

            @Override
            public final Id<T> id() {
                return this.id;
            }

            @Override
            public final Class<V> targetType() {
                return this.targetType;
            }

            @Override
            public final String attributeName() {
                return this.attributeName;
            }

            @Override
            public final DynamoDBAttributeType attributeType() {
                return this.attributeType;
            }

            @Override
            public final KeyType keyType() {
                return this.keyType;
            }

            @Override
            public final boolean versioned() {
                return this.versioned;
            }

            @Override
            public final Map<KeyType, List<String>> globalSecondaryIndexNames() {
                return this.globalSecondaryIndexNames;
            }

            @Override
            public final List<String> localSecondaryIndexNames() {
                return this.localSecondaryIndexNames;
            }

            @Override
            public final DynamoDBAutoGenerator<V> autoGenerator() {
                return this.autoGenerator;
            }

            @Override
            public final <S> DynamoDBTypeConverter<S, V> typeConverter() {
                return this.typeConverter;
            }
        }
    }

    static class Builder<T, V>
    extends Properties.Buildable<T, V> {
        private DynamoDBTypeConverter<AttributeValue, V> attributeValueConverter;
        private Reflect<T, V> reflect;

        public Builder(Properties<T, V> ... defaults) {
            super(defaults);
        }

        public final Builder<T, V> with(DynamoDBTypeConverter<AttributeValue, V> attributeValueConverter) {
            this.attributeValueConverter = attributeValueConverter;
            return this;
        }

        public final Builder<T, V> with(Reflect<T, V> reflect) {
            this.reflect = reflect;
            return this;
        }

        public final DynamoDBMapperFieldModel<T, V> build() {
            if (this.keyType() != null) {
                if (!this.attributeType().name().matches("[BNS]")) {
                    throw new DynamoDBMappingException(this.id().err("must be scalar (B, N, or S) for key but is %s", new Object[]{this.attributeType()}));
                }
                if (this.autoGenerator() != null && this.autoGenerator().getGenerateStrategy() == DynamoDBAutoGenerateStrategy.ALWAYS) {
                    throw new DynamoDBMappingException(this.id().err("must not have auto-generated key with ALWAYS strategy", new Object[0]));
                }
            }
            return new DynamoDBMapperFieldModel(this);
        }
    }

    public static final class Id<T>
    extends DynamoDBMapperTableModel.Id<T> {
        private final String name;

        public Id(Class<T> type, String name) {
            super(type);
            this.name = name;
        }

        public Id(Id<T> id, String name) {
            super(id);
            this.name = name;
        }

        @Override
        public final boolean equals(Object o) {
            return o instanceof Id && super.equals(o) && ((Id)o).name.equals(this.name);
        }

        @Override
        public final int hashCode() {
            return super.hashCode() ^ this.name.hashCode();
        }

        @Override
        public final String toString() {
            return super.toString() + "[" + this.name + "]";
        }
    }

    public static enum DynamoDBAttributeType {
        B,
        N,
        S,
        BS,
        NS,
        SS,
        BOOL,
        NULL,
        L,
        M;

    }
}

