/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationdiscovery.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.applicationdiscovery.model.DescribeAgentsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class DescribeAgentsRequestMarshaller
implements Marshaller<Request<DescribeAgentsRequest>, DescribeAgentsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeAgentsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeAgentsRequest> marshall(DescribeAgentsRequest describeAgentsRequest) {
        if (describeAgentsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeAgentsRequest> request = new DefaultRequest<DescribeAgentsRequest>(describeAgentsRequest, "AWSApplicationDiscovery");
        request.addHeader("X-Amz-Target", "AWSPoseidonService_V2015_11_01.DescribeAgents");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> agentIdsList = describeAgentsRequest.getAgentIds();
            if (agentIdsList != null) {
                jsonGenerator.writeFieldName("agentIds");
                jsonGenerator.writeStartArray();
                for (String agentIdsListValue : agentIdsList) {
                    if (agentIdsListValue == null) continue;
                    jsonGenerator.writeValue(agentIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeAgentsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(describeAgentsRequest.getMaxResults());
            }
            if (describeAgentsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(describeAgentsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

