/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.UpdateBuildRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateBuildRequestMarshaller
implements Marshaller<Request<UpdateBuildRequest>, UpdateBuildRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateBuildRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateBuildRequest> marshall(UpdateBuildRequest updateBuildRequest) {
        if (updateBuildRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateBuildRequest> request = new DefaultRequest<UpdateBuildRequest>(updateBuildRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.UpdateBuild");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateBuildRequest.getBuildId() != null) {
                jsonGenerator.writeFieldName("BuildId").writeValue(updateBuildRequest.getBuildId());
            }
            if (updateBuildRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(updateBuildRequest.getName());
            }
            if (updateBuildRequest.getVersion() != null) {
                jsonGenerator.writeFieldName("Version").writeValue(updateBuildRequest.getVersion());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

