/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerated;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerator;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.math.BigInteger;
import java.util.Arrays;

@DynamoDB
@DynamoDBAutoGenerated(generator=Generator.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
public @interface DynamoDBVersionAttribute {
    public String attributeName() default "";

    public static final class Generator<T>
    implements DynamoDBAutoGenerator<T> {
        private final Sequence<T> sequence;

        public Generator(Class<T> targetType, DynamoDBVersionAttribute annotation) {
            this.sequence = Sequences.of(targetType);
        }

        @Override
        public final DynamoDBAutoGenerateStrategy getGenerateStrategy() {
            return DynamoDBAutoGenerateStrategy.ALWAYS;
        }

        @Override
        public final T generate(T currentValue) {
            return this.sequence.next(currentValue);
        }

        private static enum Sequences {
            BIG_INTEGER(StandardTypeConverters.Scalar.BIG_INTEGER, new Sequence<BigInteger>(){

                @Override
                public final BigInteger next(BigInteger o) {
                    return o == null ? BigInteger.ONE : o.add(BigInteger.ONE);
                }
            }),
            BYTE(StandardTypeConverters.Scalar.BYTE, new Sequence<Byte>(){

                @Override
                public final Byte next(Byte o) {
                    return o == null ? Byte.valueOf((byte)1) : (byte)((o + 1) % 127);
                }
            }),
            INTEGER(StandardTypeConverters.Scalar.INTEGER, new Sequence<Integer>(){

                @Override
                public final Integer next(Integer o) {
                    return o == null ? Integer.valueOf(1) : o + 1;
                }
            }),
            LONG(StandardTypeConverters.Scalar.LONG, new Sequence<Long>(){

                @Override
                public final Long next(Long o) {
                    return o == null ? Long.valueOf(1L) : o + 1L;
                }
            }),
            SHORT(StandardTypeConverters.Scalar.SHORT, new Sequence<Short>(){

                @Override
                public final Short next(Short o) {
                    return o == null ? Short.valueOf((short)1) : (short)(o + 1);
                }
            });

            private final Sequence<?> sequence;
            private final StandardTypeConverters.Scalar scalar;

            private Sequences(StandardTypeConverters.Scalar scalar, Sequence<?> sequence) {
                this.sequence = sequence;
                this.scalar = scalar;
            }

            private static final <T> Sequence<T> of(final Class<T> targetType) {
                StandardTypeConverters.Scalar target = StandardTypeConverters.Scalar.of(targetType);
                for (Sequences s : Sequences.values()) {
                    if (s.scalar != target) continue;
                    return s.sequence;
                }
                return new Sequence<T>(){

                    @Override
                    public T next(T o) {
                        throw new DynamoDBMappingException("type [" + targetType + "] is not supported; only " + Arrays.toString((Object[])Sequences.values()) + " allowed");
                    }
                };
            }
        }

        static interface Sequence<T> {
            public T next(T var1);
        }
    }
}

