/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.AdminListDevicesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class AdminListDevicesRequestMarshaller
implements Marshaller<Request<AdminListDevicesRequest>, AdminListDevicesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public AdminListDevicesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AdminListDevicesRequest> marshall(AdminListDevicesRequest adminListDevicesRequest) {
        if (adminListDevicesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AdminListDevicesRequest> request = new DefaultRequest<AdminListDevicesRequest>(adminListDevicesRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.AdminListDevices");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (adminListDevicesRequest.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(adminListDevicesRequest.getUserPoolId());
            }
            if (adminListDevicesRequest.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(adminListDevicesRequest.getUsername());
            }
            if (adminListDevicesRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(adminListDevicesRequest.getLimit());
            }
            if (adminListDevicesRequest.getPaginationToken() != null) {
                jsonGenerator.writeFieldName("PaginationToken").writeValue(adminListDevicesRequest.getPaginationToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

