/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.Artifact;
import com.amazonaws.services.codepipeline.model.JobData;
import com.amazonaws.services.codepipeline.model.transform.AWSSessionCredentialsJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ActionConfigurationJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ActionTypeIdJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ArtifactJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.EncryptionKeyJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.PipelineContextJsonMarshaller;
import java.util.List;

public class JobDataJsonMarshaller {
    private static JobDataJsonMarshaller instance;

    public void marshall(JobData jobData, StructuredJsonGenerator jsonGenerator) {
        if (jobData == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Artifact> outputArtifactsList;
            List<Artifact> inputArtifactsList;
            jsonGenerator.writeStartObject();
            if (jobData.getActionTypeId() != null) {
                jsonGenerator.writeFieldName("actionTypeId");
                ActionTypeIdJsonMarshaller.getInstance().marshall(jobData.getActionTypeId(), jsonGenerator);
            }
            if (jobData.getActionConfiguration() != null) {
                jsonGenerator.writeFieldName("actionConfiguration");
                ActionConfigurationJsonMarshaller.getInstance().marshall(jobData.getActionConfiguration(), jsonGenerator);
            }
            if (jobData.getPipelineContext() != null) {
                jsonGenerator.writeFieldName("pipelineContext");
                PipelineContextJsonMarshaller.getInstance().marshall(jobData.getPipelineContext(), jsonGenerator);
            }
            if ((inputArtifactsList = jobData.getInputArtifacts()) != null) {
                jsonGenerator.writeFieldName("inputArtifacts");
                jsonGenerator.writeStartArray();
                for (Artifact inputArtifactsListValue : inputArtifactsList) {
                    if (inputArtifactsListValue == null) continue;
                    ArtifactJsonMarshaller.getInstance().marshall(inputArtifactsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((outputArtifactsList = jobData.getOutputArtifacts()) != null) {
                jsonGenerator.writeFieldName("outputArtifacts");
                jsonGenerator.writeStartArray();
                for (Artifact outputArtifactsListValue : outputArtifactsList) {
                    if (outputArtifactsListValue == null) continue;
                    ArtifactJsonMarshaller.getInstance().marshall(outputArtifactsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (jobData.getArtifactCredentials() != null) {
                jsonGenerator.writeFieldName("artifactCredentials");
                AWSSessionCredentialsJsonMarshaller.getInstance().marshall(jobData.getArtifactCredentials(), jsonGenerator);
            }
            if (jobData.getContinuationToken() != null) {
                jsonGenerator.writeFieldName("continuationToken").writeValue(jobData.getContinuationToken());
            }
            if (jobData.getEncryptionKey() != null) {
                jsonGenerator.writeFieldName("encryptionKey");
                EncryptionKeyJsonMarshaller.getInstance().marshall(jobData.getEncryptionKey(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobDataJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobDataJsonMarshaller();
        }
        return instance;
    }
}

