/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.QueryStringCacheKeys;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class QueryStringCacheKeysStaxUnmarshaller
implements Unmarshaller<QueryStringCacheKeys, StaxUnmarshallerContext> {
    private static QueryStringCacheKeysStaxUnmarshaller instance;

    @Override
    public QueryStringCacheKeys unmarshall(StaxUnmarshallerContext context) throws Exception {
        QueryStringCacheKeys queryStringCacheKeys = new QueryStringCacheKeys();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return queryStringCacheKeys;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    queryStringCacheKeys.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Items/Name", targetDepth)) continue;
                queryStringCacheKeys.withItems(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return queryStringCacheKeys;
    }

    public static QueryStringCacheKeysStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new QueryStringCacheKeysStaxUnmarshaller();
        }
        return instance;
    }
}

