/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetSdkRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class GetSdkRequestMarshaller
implements Marshaller<Request<GetSdkRequest>, GetSdkRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetSdkRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetSdkRequest> marshall(GetSdkRequest getSdkRequest) {
        if (getSdkRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetSdkRequest> request = new DefaultRequest<GetSdkRequest>(getSdkRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/stages/{stage_name}/sdks/{sdk_type}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getSdkRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getSdkRequest.getRestApiId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{stage_name}", getSdkRequest.getStageName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getSdkRequest.getStageName()), false) : "");
        uriResourcePath = uriResourcePath.replace("{sdk_type}", getSdkRequest.getSdkType() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getSdkRequest.getSdkType()), false) : "");
        request.setResourcePath(uriResourcePath);
        Map<String, String> parameters = getSdkRequest.getParameters();
        if (parameters != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if (entry.getValue() == null) continue;
                request.addParameter(StringUtils.fromString(entry.getKey()), StringUtils.fromString(entry.getValue()));
            }
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

