/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.shield.model.AttackLayer;
import com.amazonaws.services.shield.model.AttackPropertyIdentifier;
import com.amazonaws.services.shield.model.Contributor;
import com.amazonaws.services.shield.model.Unit;
import com.amazonaws.services.shield.model.transform.AttackPropertyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AttackProperty
implements Serializable,
Cloneable,
StructuredPojo {
    private String attackLayer;
    private String attackPropertyIdentifier;
    private List<Contributor> topContributors;
    private String unit;
    private Long total;

    public void setAttackLayer(String attackLayer) {
        this.attackLayer = attackLayer;
    }

    public String getAttackLayer() {
        return this.attackLayer;
    }

    public AttackProperty withAttackLayer(String attackLayer) {
        this.setAttackLayer(attackLayer);
        return this;
    }

    public AttackProperty withAttackLayer(AttackLayer attackLayer) {
        this.attackLayer = attackLayer.toString();
        return this;
    }

    public void setAttackPropertyIdentifier(String attackPropertyIdentifier) {
        this.attackPropertyIdentifier = attackPropertyIdentifier;
    }

    public String getAttackPropertyIdentifier() {
        return this.attackPropertyIdentifier;
    }

    public AttackProperty withAttackPropertyIdentifier(String attackPropertyIdentifier) {
        this.setAttackPropertyIdentifier(attackPropertyIdentifier);
        return this;
    }

    public AttackProperty withAttackPropertyIdentifier(AttackPropertyIdentifier attackPropertyIdentifier) {
        this.attackPropertyIdentifier = attackPropertyIdentifier.toString();
        return this;
    }

    public List<Contributor> getTopContributors() {
        return this.topContributors;
    }

    public void setTopContributors(Collection<Contributor> topContributors) {
        if (topContributors == null) {
            this.topContributors = null;
            return;
        }
        this.topContributors = new ArrayList<Contributor>(topContributors);
    }

    public AttackProperty withTopContributors(Contributor ... topContributors) {
        if (this.topContributors == null) {
            this.setTopContributors(new ArrayList<Contributor>(topContributors.length));
        }
        for (Contributor ele : topContributors) {
            this.topContributors.add(ele);
        }
        return this;
    }

    public AttackProperty withTopContributors(Collection<Contributor> topContributors) {
        this.setTopContributors(topContributors);
        return this;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }

    public AttackProperty withUnit(String unit) {
        this.setUnit(unit);
        return this;
    }

    public AttackProperty withUnit(Unit unit) {
        this.unit = unit.toString();
        return this;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public Long getTotal() {
        return this.total;
    }

    public AttackProperty withTotal(Long total) {
        this.setTotal(total);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttackLayer() != null) {
            sb.append("AttackLayer: ").append(this.getAttackLayer()).append(",");
        }
        if (this.getAttackPropertyIdentifier() != null) {
            sb.append("AttackPropertyIdentifier: ").append(this.getAttackPropertyIdentifier()).append(",");
        }
        if (this.getTopContributors() != null) {
            sb.append("TopContributors: ").append(this.getTopContributors()).append(",");
        }
        if (this.getUnit() != null) {
            sb.append("Unit: ").append(this.getUnit()).append(",");
        }
        if (this.getTotal() != null) {
            sb.append("Total: ").append(this.getTotal());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttackProperty)) {
            return false;
        }
        AttackProperty other = (AttackProperty)obj;
        if (other.getAttackLayer() == null ^ this.getAttackLayer() == null) {
            return false;
        }
        if (other.getAttackLayer() != null && !other.getAttackLayer().equals(this.getAttackLayer())) {
            return false;
        }
        if (other.getAttackPropertyIdentifier() == null ^ this.getAttackPropertyIdentifier() == null) {
            return false;
        }
        if (other.getAttackPropertyIdentifier() != null && !other.getAttackPropertyIdentifier().equals(this.getAttackPropertyIdentifier())) {
            return false;
        }
        if (other.getTopContributors() == null ^ this.getTopContributors() == null) {
            return false;
        }
        if (other.getTopContributors() != null && !other.getTopContributors().equals(this.getTopContributors())) {
            return false;
        }
        if (other.getUnit() == null ^ this.getUnit() == null) {
            return false;
        }
        if (other.getUnit() != null && !other.getUnit().equals(this.getUnit())) {
            return false;
        }
        if (other.getTotal() == null ^ this.getTotal() == null) {
            return false;
        }
        return other.getTotal() == null || other.getTotal().equals(this.getTotal());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttackLayer() == null ? 0 : this.getAttackLayer().hashCode());
        hashCode = 31 * hashCode + (this.getAttackPropertyIdentifier() == null ? 0 : this.getAttackPropertyIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTopContributors() == null ? 0 : this.getTopContributors().hashCode());
        hashCode = 31 * hashCode + (this.getUnit() == null ? 0 : this.getUnit().hashCode());
        hashCode = 31 * hashCode + (this.getTotal() == null ? 0 : this.getTotal().hashCode());
        return hashCode;
    }

    public AttackProperty clone() {
        try {
            return (AttackProperty)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttackPropertyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

