/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicediscovery.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.servicediscovery.model.DnsRecord;
import com.amazonaws.services.servicediscovery.model.transform.DnsConfigChangeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DnsConfigChange
implements Serializable,
Cloneable,
StructuredPojo {
    private List<DnsRecord> dnsRecords;

    public List<DnsRecord> getDnsRecords() {
        return this.dnsRecords;
    }

    public void setDnsRecords(Collection<DnsRecord> dnsRecords) {
        if (dnsRecords == null) {
            this.dnsRecords = null;
            return;
        }
        this.dnsRecords = new ArrayList<DnsRecord>(dnsRecords);
    }

    public DnsConfigChange withDnsRecords(DnsRecord ... dnsRecords) {
        if (this.dnsRecords == null) {
            this.setDnsRecords(new ArrayList<DnsRecord>(dnsRecords.length));
        }
        for (DnsRecord ele : dnsRecords) {
            this.dnsRecords.add(ele);
        }
        return this;
    }

    public DnsConfigChange withDnsRecords(Collection<DnsRecord> dnsRecords) {
        this.setDnsRecords(dnsRecords);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDnsRecords() != null) {
            sb.append("DnsRecords: ").append(this.getDnsRecords());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsConfigChange)) {
            return false;
        }
        DnsConfigChange other = (DnsConfigChange)obj;
        if (other.getDnsRecords() == null ^ this.getDnsRecords() == null) {
            return false;
        }
        return other.getDnsRecords() == null || other.getDnsRecords().equals(this.getDnsRecords());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDnsRecords() == null ? 0 : this.getDnsRecords().hashCode());
        return hashCode;
    }

    public DnsConfigChange clone() {
        try {
            return (DnsConfigChange)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DnsConfigChangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

