/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.TestDNSAnswerRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class TestDNSAnswerRequestMarshaller
implements Marshaller<Request<TestDNSAnswerRequest>, TestDNSAnswerRequest> {
    @Override
    public Request<TestDNSAnswerRequest> marshall(TestDNSAnswerRequest testDNSAnswerRequest) {
        if (testDNSAnswerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<TestDNSAnswerRequest> request = new DefaultRequest<TestDNSAnswerRequest>(testDNSAnswerRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/testdnsanswer";
        request.setResourcePath(uriResourcePath);
        if (testDNSAnswerRequest.getHostedZoneId() != null) {
            request.addParameter("hostedzoneid", StringUtils.fromString(testDNSAnswerRequest.getHostedZoneId()));
        }
        if (testDNSAnswerRequest.getRecordName() != null) {
            request.addParameter("recordname", StringUtils.fromString(testDNSAnswerRequest.getRecordName()));
        }
        if (testDNSAnswerRequest.getRecordType() != null) {
            request.addParameter("recordtype", StringUtils.fromString(testDNSAnswerRequest.getRecordType()));
        }
        if (testDNSAnswerRequest.getResolverIP() != null) {
            request.addParameter("resolverip", StringUtils.fromString(testDNSAnswerRequest.getResolverIP()));
        }
        if (testDNSAnswerRequest.getEDNS0ClientSubnetIP() != null) {
            request.addParameter("edns0clientsubnetip", StringUtils.fromString(testDNSAnswerRequest.getEDNS0ClientSubnetIP()));
        }
        if (testDNSAnswerRequest.getEDNS0ClientSubnetMask() != null) {
            request.addParameter("edns0clientsubnetmask", StringUtils.fromString(testDNSAnswerRequest.getEDNS0ClientSubnetMask()));
        }
        return request;
    }
}

