/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.transform.ConnectionsListMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConnectionsList
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> connections;

    public List<String> getConnections() {
        return this.connections;
    }

    public void setConnections(Collection<String> connections) {
        if (connections == null) {
            this.connections = null;
            return;
        }
        this.connections = new ArrayList<String>(connections);
    }

    public ConnectionsList withConnections(String ... connections) {
        if (this.connections == null) {
            this.setConnections(new ArrayList<String>(connections.length));
        }
        for (String ele : connections) {
            this.connections.add(ele);
        }
        return this;
    }

    public ConnectionsList withConnections(Collection<String> connections) {
        this.setConnections(connections);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConnections() != null) {
            sb.append("Connections: ").append(this.getConnections());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionsList)) {
            return false;
        }
        ConnectionsList other = (ConnectionsList)obj;
        if (other.getConnections() == null ^ this.getConnections() == null) {
            return false;
        }
        return other.getConnections() == null || other.getConnections().equals(this.getConnections());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConnections() == null ? 0 : this.getConnections().hashCode());
        return hashCode;
    }

    public ConnectionsList clone() {
        try {
            return (ConnectionsList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConnectionsListMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

