/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeLaunchTemplatesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeLaunchTemplatesRequestMarshaller
implements Marshaller<Request<DescribeLaunchTemplatesRequest>, DescribeLaunchTemplatesRequest> {
    @Override
    public Request<DescribeLaunchTemplatesRequest> marshall(DescribeLaunchTemplatesRequest describeLaunchTemplatesRequest) {
        SdkInternalList describeLaunchTemplatesRequestFiltersList;
        SdkInternalList describeLaunchTemplatesRequestLaunchTemplateNamesList;
        if (describeLaunchTemplatesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeLaunchTemplatesRequest> request = new DefaultRequest<DescribeLaunchTemplatesRequest>(describeLaunchTemplatesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeLaunchTemplates");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeLaunchTemplatesRequestLaunchTemplateIdsList = (SdkInternalList)describeLaunchTemplatesRequest.getLaunchTemplateIds();
        if (!describeLaunchTemplatesRequestLaunchTemplateIdsList.isEmpty() || !describeLaunchTemplatesRequestLaunchTemplateIdsList.isAutoConstruct()) {
            int launchTemplateIdsListIndex = 1;
            for (Object describeLaunchTemplatesRequestLaunchTemplateIdsListValue : describeLaunchTemplatesRequestLaunchTemplateIdsList) {
                if (describeLaunchTemplatesRequestLaunchTemplateIdsListValue != null) {
                    request.addParameter("LaunchTemplateId." + launchTemplateIdsListIndex, StringUtils.fromString((String)describeLaunchTemplatesRequestLaunchTemplateIdsListValue));
                }
                ++launchTemplateIdsListIndex;
            }
        }
        if (!(describeLaunchTemplatesRequestLaunchTemplateNamesList = (SdkInternalList)describeLaunchTemplatesRequest.getLaunchTemplateNames()).isEmpty() || !describeLaunchTemplatesRequestLaunchTemplateNamesList.isAutoConstruct()) {
            int launchTemplateNamesListIndex = 1;
            for (String describeLaunchTemplatesRequestLaunchTemplateNamesListValue : describeLaunchTemplatesRequestLaunchTemplateNamesList) {
                if (describeLaunchTemplatesRequestLaunchTemplateNamesListValue != null) {
                    request.addParameter("LaunchTemplateName." + launchTemplateNamesListIndex, StringUtils.fromString(describeLaunchTemplatesRequestLaunchTemplateNamesListValue));
                }
                ++launchTemplateNamesListIndex;
            }
        }
        if (!(describeLaunchTemplatesRequestFiltersList = (SdkInternalList)describeLaunchTemplatesRequest.getFilters()).isEmpty() || !describeLaunchTemplatesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeLaunchTemplatesRequestFiltersListValue : describeLaunchTemplatesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeLaunchTemplatesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeLaunchTemplatesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeLaunchTemplatesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeLaunchTemplatesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeLaunchTemplatesRequest.getNextToken()));
        }
        if (describeLaunchTemplatesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeLaunchTemplatesRequest.getMaxResults()));
        }
        return request;
    }
}

