/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codecommit.model.MergeMetadata;

@SdkInternalApi
public class MergeMetadataMarshaller {
    private static final MarshallingInfo<Boolean> ISMERGED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isMerged").build();
    private static final MarshallingInfo<String> MERGEDBY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mergedBy").build();
    private static final MergeMetadataMarshaller instance = new MergeMetadataMarshaller();

    public static MergeMetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(MergeMetadata mergeMetadata, ProtocolMarshaller protocolMarshaller) {
        if (mergeMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(mergeMetadata.getIsMerged(), ISMERGED_BINDING);
            protocolMarshaller.marshall(mergeMetadata.getMergedBy(), MERGEDBY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

