/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AccountAttributeName;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.DescribeAccountAttributesRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeAccountAttributesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeAccountAttributesRequest> {
    private SdkInternalList<String> attributeNames;

    public List<String> getAttributeNames() {
        if (this.attributeNames == null) {
            this.attributeNames = new SdkInternalList();
        }
        return this.attributeNames;
    }

    public void setAttributeNames(Collection<String> attributeNames) {
        if (attributeNames == null) {
            this.attributeNames = null;
            return;
        }
        this.attributeNames = new SdkInternalList<String>(attributeNames);
    }

    public DescribeAccountAttributesRequest withAttributeNames(String ... attributeNames) {
        if (this.attributeNames == null) {
            this.setAttributeNames(new SdkInternalList<String>(attributeNames.length));
        }
        for (String ele : attributeNames) {
            this.attributeNames.add(ele);
        }
        return this;
    }

    public DescribeAccountAttributesRequest withAttributeNames(Collection<String> attributeNames) {
        this.setAttributeNames(attributeNames);
        return this;
    }

    public DescribeAccountAttributesRequest withAttributeNames(AccountAttributeName ... attributeNames) {
        SdkInternalList<String> attributeNamesCopy = new SdkInternalList<String>(attributeNames.length);
        for (AccountAttributeName value : attributeNames) {
            attributeNamesCopy.add(value.toString());
        }
        if (this.getAttributeNames() == null) {
            this.setAttributeNames(attributeNamesCopy);
        } else {
            this.getAttributeNames().addAll(attributeNamesCopy);
        }
        return this;
    }

    @Override
    public Request<DescribeAccountAttributesRequest> getDryRunRequest() {
        Request<DescribeAccountAttributesRequest> request = new DescribeAccountAttributesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributeNames() != null) {
            sb.append("AttributeNames: " + this.getAttributeNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAttributesRequest)) {
            return false;
        }
        DescribeAccountAttributesRequest other = (DescribeAccountAttributesRequest)obj;
        if (other.getAttributeNames() == null ^ this.getAttributeNames() == null) {
            return false;
        }
        return other.getAttributeNames() == null || other.getAttributeNames().equals(this.getAttributeNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributeNames() == null ? 0 : this.getAttributeNames().hashCode());
        return hashCode;
    }

    @Override
    public DescribeAccountAttributesRequest clone() {
        return (DescribeAccountAttributesRequest)super.clone();
    }
}

