/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.ListTagsForVaultRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListTagsForVaultRequestMarshaller
implements Marshaller<Request<ListTagsForVaultRequest>, ListTagsForVaultRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListTagsForVaultRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListTagsForVaultRequest> marshall(ListTagsForVaultRequest listTagsForVaultRequest) {
        if (listTagsForVaultRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListTagsForVaultRequest> request = new DefaultRequest<ListTagsForVaultRequest>(listTagsForVaultRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/tags";
        uriResourcePath = uriResourcePath.replace("{accountId}", listTagsForVaultRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(listTagsForVaultRequest.getAccountId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", listTagsForVaultRequest.getVaultName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(listTagsForVaultRequest.getVaultName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

