/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.ListDistributionsByWebACLIdRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;

public class ListDistributionsByWebACLIdRequestMarshaller
implements Marshaller<Request<ListDistributionsByWebACLIdRequest>, ListDistributionsByWebACLIdRequest> {
    @Override
    public Request<ListDistributionsByWebACLIdRequest> marshall(ListDistributionsByWebACLIdRequest listDistributionsByWebACLIdRequest) {
        if (listDistributionsByWebACLIdRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDistributionsByWebACLIdRequest> request = new DefaultRequest<ListDistributionsByWebACLIdRequest>(listDistributionsByWebACLIdRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2016-08-01/distributionsByWebACLId/{WebACLId}";
        uriResourcePath = uriResourcePath.replace("{WebACLId}", listDistributionsByWebACLIdRequest.getWebACLId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(listDistributionsByWebACLIdRequest.getWebACLId()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (listDistributionsByWebACLIdRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listDistributionsByWebACLIdRequest.getMarker()));
        }
        if (listDistributionsByWebACLIdRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromString(listDistributionsByWebACLIdRequest.getMaxItems()));
        }
        return request;
    }
}

