/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servermigration;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.servermigration.AWSServerMigration;
import com.amazonaws.services.servermigration.AWSServerMigrationClientBuilder;
import com.amazonaws.services.servermigration.model.AWSServerMigrationException;
import com.amazonaws.services.servermigration.model.CreateReplicationJobRequest;
import com.amazonaws.services.servermigration.model.CreateReplicationJobResult;
import com.amazonaws.services.servermigration.model.DeleteReplicationJobRequest;
import com.amazonaws.services.servermigration.model.DeleteReplicationJobResult;
import com.amazonaws.services.servermigration.model.DeleteServerCatalogRequest;
import com.amazonaws.services.servermigration.model.DeleteServerCatalogResult;
import com.amazonaws.services.servermigration.model.DisassociateConnectorRequest;
import com.amazonaws.services.servermigration.model.DisassociateConnectorResult;
import com.amazonaws.services.servermigration.model.GetConnectorsRequest;
import com.amazonaws.services.servermigration.model.GetConnectorsResult;
import com.amazonaws.services.servermigration.model.GetReplicationJobsRequest;
import com.amazonaws.services.servermigration.model.GetReplicationJobsResult;
import com.amazonaws.services.servermigration.model.GetReplicationRunsRequest;
import com.amazonaws.services.servermigration.model.GetReplicationRunsResult;
import com.amazonaws.services.servermigration.model.GetServersRequest;
import com.amazonaws.services.servermigration.model.GetServersResult;
import com.amazonaws.services.servermigration.model.ImportServerCatalogRequest;
import com.amazonaws.services.servermigration.model.ImportServerCatalogResult;
import com.amazonaws.services.servermigration.model.InternalErrorException;
import com.amazonaws.services.servermigration.model.InvalidParameterException;
import com.amazonaws.services.servermigration.model.MissingRequiredParameterException;
import com.amazonaws.services.servermigration.model.NoConnectorsAvailableException;
import com.amazonaws.services.servermigration.model.OperationNotPermittedException;
import com.amazonaws.services.servermigration.model.ReplicationJobAlreadyExistsException;
import com.amazonaws.services.servermigration.model.ReplicationJobNotFoundException;
import com.amazonaws.services.servermigration.model.ReplicationRunLimitExceededException;
import com.amazonaws.services.servermigration.model.ServerCannotBeReplicatedException;
import com.amazonaws.services.servermigration.model.StartOnDemandReplicationRunRequest;
import com.amazonaws.services.servermigration.model.StartOnDemandReplicationRunResult;
import com.amazonaws.services.servermigration.model.UnauthorizedOperationException;
import com.amazonaws.services.servermigration.model.UpdateReplicationJobRequest;
import com.amazonaws.services.servermigration.model.UpdateReplicationJobResult;
import com.amazonaws.services.servermigration.model.transform.CreateReplicationJobRequestProtocolMarshaller;
import com.amazonaws.services.servermigration.model.transform.CreateReplicationJobResultJsonUnmarshaller;
import com.amazonaws.services.servermigration.model.transform.DeleteReplicationJobRequestProtocolMarshaller;
import com.amazonaws.services.servermigration.model.transform.DeleteReplicationJobResultJsonUnmarshaller;
import com.amazonaws.services.servermigration.model.transform.DeleteServerCatalogRequestProtocolMarshaller;
import com.amazonaws.services.servermigration.model.transform.DeleteServerCatalogResultJsonUnmarshaller;
import com.amazonaws.services.servermigration.model.transform.DisassociateConnectorRequestProtocolMarshaller;
import com.amazonaws.services.servermigration.model.transform.DisassociateConnectorResultJsonUnmarshaller;
import com.amazonaws.services.servermigration.model.transform.GetConnectorsRequestProtocolMarshaller;
import com.amazonaws.services.servermigration.model.transform.GetConnectorsResultJsonUnmarshaller;
import com.amazonaws.services.servermigration.model.transform.GetReplicationJobsRequestProtocolMarshaller;
import com.amazonaws.services.servermigration.model.transform.GetReplicationJobsResultJsonUnmarshaller;
import com.amazonaws.services.servermigration.model.transform.GetReplicationRunsRequestProtocolMarshaller;
import com.amazonaws.services.servermigration.model.transform.GetReplicationRunsResultJsonUnmarshaller;
import com.amazonaws.services.servermigration.model.transform.GetServersRequestProtocolMarshaller;
import com.amazonaws.services.servermigration.model.transform.GetServersResultJsonUnmarshaller;
import com.amazonaws.services.servermigration.model.transform.ImportServerCatalogRequestProtocolMarshaller;
import com.amazonaws.services.servermigration.model.transform.ImportServerCatalogResultJsonUnmarshaller;
import com.amazonaws.services.servermigration.model.transform.StartOnDemandReplicationRunRequestProtocolMarshaller;
import com.amazonaws.services.servermigration.model.transform.StartOnDemandReplicationRunResultJsonUnmarshaller;
import com.amazonaws.services.servermigration.model.transform.UpdateReplicationJobRequestProtocolMarshaller;
import com.amazonaws.services.servermigration.model.transform.UpdateReplicationJobResultJsonUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSServerMigrationClient
extends AmazonWebServiceClient
implements AWSServerMigration {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSServerMigration.class);
    private static final String DEFAULT_SIGNING_NAME = "sms";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ReplicationJobAlreadyExistsException").withModeledClass(ReplicationJobAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MissingRequiredParameterException").withModeledClass(MissingRequiredParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServerCannotBeReplicatedException").withModeledClass(ServerCannotBeReplicatedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ReplicationJobNotFoundException").withModeledClass(ReplicationJobNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ReplicationRunLimitExceededException").withModeledClass(ReplicationRunLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OperationNotPermittedException").withModeledClass(OperationNotPermittedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedOperationException").withModeledClass(UnauthorizedOperationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalError").withModeledClass(InternalErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NoConnectorsAvailableException").withModeledClass(NoConnectorsAvailableException.class)).withBaseServiceExceptionClass(AWSServerMigrationException.class));

    @Deprecated
    public AWSServerMigrationClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSServerMigrationClient(ClientConfiguration clientConfiguration) {
        this(DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSServerMigrationClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSServerMigrationClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AWSServerMigrationClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSServerMigrationClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSServerMigrationClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AWSServerMigrationClientBuilder builder() {
        return AWSServerMigrationClientBuilder.standard();
    }

    AWSServerMigrationClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("sms.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/servermigration/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/servermigration/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateReplicationJobResult createReplicationJob(CreateReplicationJobRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateReplicationJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateReplicationJobResult executeCreateReplicationJob(CreateReplicationJobRequest createReplicationJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createReplicationJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateReplicationJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateReplicationJobRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createReplicationJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateReplicationJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateReplicationJobResult createReplicationJobResult = (CreateReplicationJobResult)response.getAwsResponse();
            return createReplicationJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteReplicationJobResult deleteReplicationJob(DeleteReplicationJobRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteReplicationJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteReplicationJobResult executeDeleteReplicationJob(DeleteReplicationJobRequest deleteReplicationJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteReplicationJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteReplicationJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteReplicationJobRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteReplicationJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteReplicationJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteReplicationJobResult deleteReplicationJobResult = (DeleteReplicationJobResult)response.getAwsResponse();
            return deleteReplicationJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteServerCatalogResult deleteServerCatalog(DeleteServerCatalogRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteServerCatalog(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteServerCatalogResult executeDeleteServerCatalog(DeleteServerCatalogRequest deleteServerCatalogRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteServerCatalogRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteServerCatalogRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteServerCatalogRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteServerCatalogRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteServerCatalogResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteServerCatalogResult deleteServerCatalogResult = (DeleteServerCatalogResult)response.getAwsResponse();
            return deleteServerCatalogResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateConnectorResult disassociateConnector(DisassociateConnectorRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDisassociateConnector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateConnectorResult executeDisassociateConnector(DisassociateConnectorRequest disassociateConnectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateConnectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateConnectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateConnectorRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(disassociateConnectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DisassociateConnectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateConnectorResult disassociateConnectorResult = (DisassociateConnectorResult)response.getAwsResponse();
            return disassociateConnectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetConnectorsResult getConnectors(GetConnectorsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetConnectors(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetConnectorsResult executeGetConnectors(GetConnectorsRequest getConnectorsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getConnectorsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetConnectorsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetConnectorsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getConnectorsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetConnectorsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetConnectorsResult getConnectorsResult = (GetConnectorsResult)response.getAwsResponse();
            return getConnectorsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetReplicationJobsResult getReplicationJobs(GetReplicationJobsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetReplicationJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetReplicationJobsResult executeGetReplicationJobs(GetReplicationJobsRequest getReplicationJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getReplicationJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetReplicationJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetReplicationJobsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getReplicationJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetReplicationJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetReplicationJobsResult getReplicationJobsResult = (GetReplicationJobsResult)response.getAwsResponse();
            return getReplicationJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetReplicationRunsResult getReplicationRuns(GetReplicationRunsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetReplicationRuns(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetReplicationRunsResult executeGetReplicationRuns(GetReplicationRunsRequest getReplicationRunsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getReplicationRunsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetReplicationRunsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetReplicationRunsRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getReplicationRunsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetReplicationRunsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetReplicationRunsResult getReplicationRunsResult = (GetReplicationRunsResult)response.getAwsResponse();
            return getReplicationRunsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetServersResult getServers(GetServersRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetServers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetServersResult executeGetServers(GetServersRequest getServersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getServersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetServersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetServersRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getServersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetServersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetServersResult getServersResult = (GetServersResult)response.getAwsResponse();
            return getServersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ImportServerCatalogResult importServerCatalog(ImportServerCatalogRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeImportServerCatalog(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ImportServerCatalogResult executeImportServerCatalog(ImportServerCatalogRequest importServerCatalogRequest) {
        ExecutionContext executionContext = this.createExecutionContext(importServerCatalogRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ImportServerCatalogRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ImportServerCatalogRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(importServerCatalogRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ImportServerCatalogResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ImportServerCatalogResult importServerCatalogResult = (ImportServerCatalogResult)response.getAwsResponse();
            return importServerCatalogResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartOnDemandReplicationRunResult startOnDemandReplicationRun(StartOnDemandReplicationRunRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStartOnDemandReplicationRun(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartOnDemandReplicationRunResult executeStartOnDemandReplicationRun(StartOnDemandReplicationRunRequest startOnDemandReplicationRunRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startOnDemandReplicationRunRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartOnDemandReplicationRunRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartOnDemandReplicationRunRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(startOnDemandReplicationRunRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StartOnDemandReplicationRunResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartOnDemandReplicationRunResult startOnDemandReplicationRunResult = (StartOnDemandReplicationRunResult)response.getAwsResponse();
            return startOnDemandReplicationRunResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateReplicationJobResult updateReplicationJob(UpdateReplicationJobRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateReplicationJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateReplicationJobResult executeUpdateReplicationJob(UpdateReplicationJobRequest updateReplicationJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateReplicationJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateReplicationJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateReplicationJobRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateReplicationJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateReplicationJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateReplicationJobResult updateReplicationJobResult = (UpdateReplicationJobResult)response.getAwsResponse();
            return updateReplicationJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

