/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.medialive.model.InputDestinationRequest;
import com.amazonaws.services.medialive.model.InputSourceRequest;
import com.amazonaws.services.medialive.model.InputType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateInputRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<InputDestinationRequest> destinations;
    private List<String> inputSecurityGroups;
    private String name;
    private String requestId;
    private List<InputSourceRequest> sources;
    private String type;

    public List<InputDestinationRequest> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<InputDestinationRequest> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new ArrayList<InputDestinationRequest>(destinations);
    }

    public CreateInputRequest withDestinations(InputDestinationRequest ... destinations) {
        if (this.destinations == null) {
            this.setDestinations(new ArrayList<InputDestinationRequest>(destinations.length));
        }
        for (InputDestinationRequest ele : destinations) {
            this.destinations.add(ele);
        }
        return this;
    }

    public CreateInputRequest withDestinations(Collection<InputDestinationRequest> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public List<String> getInputSecurityGroups() {
        return this.inputSecurityGroups;
    }

    public void setInputSecurityGroups(Collection<String> inputSecurityGroups) {
        if (inputSecurityGroups == null) {
            this.inputSecurityGroups = null;
            return;
        }
        this.inputSecurityGroups = new ArrayList<String>(inputSecurityGroups);
    }

    public CreateInputRequest withInputSecurityGroups(String ... inputSecurityGroups) {
        if (this.inputSecurityGroups == null) {
            this.setInputSecurityGroups(new ArrayList<String>(inputSecurityGroups.length));
        }
        for (String ele : inputSecurityGroups) {
            this.inputSecurityGroups.add(ele);
        }
        return this;
    }

    public CreateInputRequest withInputSecurityGroups(Collection<String> inputSecurityGroups) {
        this.setInputSecurityGroups(inputSecurityGroups);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateInputRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public CreateInputRequest withRequestId(String requestId) {
        this.setRequestId(requestId);
        return this;
    }

    public List<InputSourceRequest> getSources() {
        return this.sources;
    }

    public void setSources(Collection<InputSourceRequest> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<InputSourceRequest>(sources);
    }

    public CreateInputRequest withSources(InputSourceRequest ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<InputSourceRequest>(sources.length));
        }
        for (InputSourceRequest ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public CreateInputRequest withSources(Collection<InputSourceRequest> sources) {
        this.setSources(sources);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateInputRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public CreateInputRequest withType(InputType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations()).append(",");
        }
        if (this.getInputSecurityGroups() != null) {
            sb.append("InputSecurityGroups: ").append(this.getInputSecurityGroups()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getRequestId() != null) {
            sb.append("RequestId: ").append(this.getRequestId()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInputRequest)) {
            return false;
        }
        CreateInputRequest other = (CreateInputRequest)obj;
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !other.getDestinations().equals(this.getDestinations())) {
            return false;
        }
        if (other.getInputSecurityGroups() == null ^ this.getInputSecurityGroups() == null) {
            return false;
        }
        if (other.getInputSecurityGroups() != null && !other.getInputSecurityGroups().equals(this.getInputSecurityGroups())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getRequestId() == null ^ this.getRequestId() == null) {
            return false;
        }
        if (other.getRequestId() != null && !other.getRequestId().equals(this.getRequestId())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        if (other.getSources() != null && !other.getSources().equals(this.getSources())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getInputSecurityGroups() == null ? 0 : this.getInputSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getRequestId() == null ? 0 : this.getRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    @Override
    public CreateInputRequest clone() {
        return (CreateInputRequest)super.clone();
    }
}

