/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.AudioDescription;
import com.amazonaws.services.mediaconvert.model.CaptionDescription;
import com.amazonaws.services.mediaconvert.model.ContainerSettings;
import com.amazonaws.services.mediaconvert.model.OutputSettings;
import com.amazonaws.services.mediaconvert.model.VideoDescription;
import com.amazonaws.services.mediaconvert.model.transform.OutputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Output
implements Serializable,
Cloneable,
StructuredPojo {
    private List<AudioDescription> audioDescriptions;
    private List<CaptionDescription> captionDescriptions;
    private ContainerSettings containerSettings;
    private String extension;
    private String nameModifier;
    private OutputSettings outputSettings;
    private String preset;
    private VideoDescription videoDescription;

    public List<AudioDescription> getAudioDescriptions() {
        return this.audioDescriptions;
    }

    public void setAudioDescriptions(Collection<AudioDescription> audioDescriptions) {
        if (audioDescriptions == null) {
            this.audioDescriptions = null;
            return;
        }
        this.audioDescriptions = new ArrayList<AudioDescription>(audioDescriptions);
    }

    public Output withAudioDescriptions(AudioDescription ... audioDescriptions) {
        if (this.audioDescriptions == null) {
            this.setAudioDescriptions(new ArrayList<AudioDescription>(audioDescriptions.length));
        }
        for (AudioDescription ele : audioDescriptions) {
            this.audioDescriptions.add(ele);
        }
        return this;
    }

    public Output withAudioDescriptions(Collection<AudioDescription> audioDescriptions) {
        this.setAudioDescriptions(audioDescriptions);
        return this;
    }

    public List<CaptionDescription> getCaptionDescriptions() {
        return this.captionDescriptions;
    }

    public void setCaptionDescriptions(Collection<CaptionDescription> captionDescriptions) {
        if (captionDescriptions == null) {
            this.captionDescriptions = null;
            return;
        }
        this.captionDescriptions = new ArrayList<CaptionDescription>(captionDescriptions);
    }

    public Output withCaptionDescriptions(CaptionDescription ... captionDescriptions) {
        if (this.captionDescriptions == null) {
            this.setCaptionDescriptions(new ArrayList<CaptionDescription>(captionDescriptions.length));
        }
        for (CaptionDescription ele : captionDescriptions) {
            this.captionDescriptions.add(ele);
        }
        return this;
    }

    public Output withCaptionDescriptions(Collection<CaptionDescription> captionDescriptions) {
        this.setCaptionDescriptions(captionDescriptions);
        return this;
    }

    public void setContainerSettings(ContainerSettings containerSettings) {
        this.containerSettings = containerSettings;
    }

    public ContainerSettings getContainerSettings() {
        return this.containerSettings;
    }

    public Output withContainerSettings(ContainerSettings containerSettings) {
        this.setContainerSettings(containerSettings);
        return this;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return this.extension;
    }

    public Output withExtension(String extension) {
        this.setExtension(extension);
        return this;
    }

    public void setNameModifier(String nameModifier) {
        this.nameModifier = nameModifier;
    }

    public String getNameModifier() {
        return this.nameModifier;
    }

    public Output withNameModifier(String nameModifier) {
        this.setNameModifier(nameModifier);
        return this;
    }

    public void setOutputSettings(OutputSettings outputSettings) {
        this.outputSettings = outputSettings;
    }

    public OutputSettings getOutputSettings() {
        return this.outputSettings;
    }

    public Output withOutputSettings(OutputSettings outputSettings) {
        this.setOutputSettings(outputSettings);
        return this;
    }

    public void setPreset(String preset) {
        this.preset = preset;
    }

    public String getPreset() {
        return this.preset;
    }

    public Output withPreset(String preset) {
        this.setPreset(preset);
        return this;
    }

    public void setVideoDescription(VideoDescription videoDescription) {
        this.videoDescription = videoDescription;
    }

    public VideoDescription getVideoDescription() {
        return this.videoDescription;
    }

    public Output withVideoDescription(VideoDescription videoDescription) {
        this.setVideoDescription(videoDescription);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAudioDescriptions() != null) {
            sb.append("AudioDescriptions: ").append(this.getAudioDescriptions()).append(",");
        }
        if (this.getCaptionDescriptions() != null) {
            sb.append("CaptionDescriptions: ").append(this.getCaptionDescriptions()).append(",");
        }
        if (this.getContainerSettings() != null) {
            sb.append("ContainerSettings: ").append(this.getContainerSettings()).append(",");
        }
        if (this.getExtension() != null) {
            sb.append("Extension: ").append(this.getExtension()).append(",");
        }
        if (this.getNameModifier() != null) {
            sb.append("NameModifier: ").append(this.getNameModifier()).append(",");
        }
        if (this.getOutputSettings() != null) {
            sb.append("OutputSettings: ").append(this.getOutputSettings()).append(",");
        }
        if (this.getPreset() != null) {
            sb.append("Preset: ").append(this.getPreset()).append(",");
        }
        if (this.getVideoDescription() != null) {
            sb.append("VideoDescription: ").append(this.getVideoDescription());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output)obj;
        if (other.getAudioDescriptions() == null ^ this.getAudioDescriptions() == null) {
            return false;
        }
        if (other.getAudioDescriptions() != null && !other.getAudioDescriptions().equals(this.getAudioDescriptions())) {
            return false;
        }
        if (other.getCaptionDescriptions() == null ^ this.getCaptionDescriptions() == null) {
            return false;
        }
        if (other.getCaptionDescriptions() != null && !other.getCaptionDescriptions().equals(this.getCaptionDescriptions())) {
            return false;
        }
        if (other.getContainerSettings() == null ^ this.getContainerSettings() == null) {
            return false;
        }
        if (other.getContainerSettings() != null && !other.getContainerSettings().equals(this.getContainerSettings())) {
            return false;
        }
        if (other.getExtension() == null ^ this.getExtension() == null) {
            return false;
        }
        if (other.getExtension() != null && !other.getExtension().equals(this.getExtension())) {
            return false;
        }
        if (other.getNameModifier() == null ^ this.getNameModifier() == null) {
            return false;
        }
        if (other.getNameModifier() != null && !other.getNameModifier().equals(this.getNameModifier())) {
            return false;
        }
        if (other.getOutputSettings() == null ^ this.getOutputSettings() == null) {
            return false;
        }
        if (other.getOutputSettings() != null && !other.getOutputSettings().equals(this.getOutputSettings())) {
            return false;
        }
        if (other.getPreset() == null ^ this.getPreset() == null) {
            return false;
        }
        if (other.getPreset() != null && !other.getPreset().equals(this.getPreset())) {
            return false;
        }
        if (other.getVideoDescription() == null ^ this.getVideoDescription() == null) {
            return false;
        }
        return other.getVideoDescription() == null || other.getVideoDescription().equals(this.getVideoDescription());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAudioDescriptions() == null ? 0 : this.getAudioDescriptions().hashCode());
        hashCode = 31 * hashCode + (this.getCaptionDescriptions() == null ? 0 : this.getCaptionDescriptions().hashCode());
        hashCode = 31 * hashCode + (this.getContainerSettings() == null ? 0 : this.getContainerSettings().hashCode());
        hashCode = 31 * hashCode + (this.getExtension() == null ? 0 : this.getExtension().hashCode());
        hashCode = 31 * hashCode + (this.getNameModifier() == null ? 0 : this.getNameModifier().hashCode());
        hashCode = 31 * hashCode + (this.getOutputSettings() == null ? 0 : this.getOutputSettings().hashCode());
        hashCode = 31 * hashCode + (this.getPreset() == null ? 0 : this.getPreset().hashCode());
        hashCode = 31 * hashCode + (this.getVideoDescription() == null ? 0 : this.getVideoDescription().hashCode());
        return hashCode;
    }

    public Output clone() {
        try {
            return (Output)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

