/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glacier.model.OutputSerialization;

@SdkInternalApi
public class OutputSerializationMarshaller {
    private static final MarshallingInfo<StructuredPojo> CSV_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("csv").build();
    private static final OutputSerializationMarshaller instance = new OutputSerializationMarshaller();

    public static OutputSerializationMarshaller getInstance() {
        return instance;
    }

    public void marshall(OutputSerialization outputSerialization, ProtocolMarshaller protocolMarshaller) {
        if (outputSerialization == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(outputSerialization.getCsv(), CSV_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

