/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glacier.model.CannedACL;
import com.amazonaws.services.glacier.model.Encryption;
import com.amazonaws.services.glacier.model.Grant;
import com.amazonaws.services.glacier.model.StorageClass;
import com.amazonaws.services.glacier.model.transform.S3LocationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class S3Location
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucketName;
    private String prefix;
    private Encryption encryption;
    private String cannedACL;
    private List<Grant> accessControlList;
    private Map<String, String> tagging;
    private Map<String, String> userMetadata;
    private String storageClass;

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public S3Location withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public S3Location withPrefix(String prefix) {
        this.setPrefix(prefix);
        return this;
    }

    public void setEncryption(Encryption encryption) {
        this.encryption = encryption;
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public S3Location withEncryption(Encryption encryption) {
        this.setEncryption(encryption);
        return this;
    }

    public void setCannedACL(String cannedACL) {
        this.cannedACL = cannedACL;
    }

    public String getCannedACL() {
        return this.cannedACL;
    }

    public S3Location withCannedACL(String cannedACL) {
        this.setCannedACL(cannedACL);
        return this;
    }

    public S3Location withCannedACL(CannedACL cannedACL) {
        this.cannedACL = cannedACL.toString();
        return this;
    }

    public List<Grant> getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(Collection<Grant> accessControlList) {
        if (accessControlList == null) {
            this.accessControlList = null;
            return;
        }
        this.accessControlList = new ArrayList<Grant>(accessControlList);
    }

    public S3Location withAccessControlList(Grant ... accessControlList) {
        if (this.accessControlList == null) {
            this.setAccessControlList(new ArrayList<Grant>(accessControlList.length));
        }
        for (Grant ele : accessControlList) {
            this.accessControlList.add(ele);
        }
        return this;
    }

    public S3Location withAccessControlList(Collection<Grant> accessControlList) {
        this.setAccessControlList(accessControlList);
        return this;
    }

    public Map<String, String> getTagging() {
        return this.tagging;
    }

    public void setTagging(Map<String, String> tagging) {
        this.tagging = tagging;
    }

    public S3Location withTagging(Map<String, String> tagging) {
        this.setTagging(tagging);
        return this;
    }

    public S3Location addTaggingEntry(String key, String value) {
        if (null == this.tagging) {
            this.tagging = new HashMap<String, String>();
        }
        if (this.tagging.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tagging.put(key, value);
        return this;
    }

    public S3Location clearTaggingEntries() {
        this.tagging = null;
        return this;
    }

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    public S3Location withUserMetadata(Map<String, String> userMetadata) {
        this.setUserMetadata(userMetadata);
        return this;
    }

    public S3Location addUserMetadataEntry(String key, String value) {
        if (null == this.userMetadata) {
            this.userMetadata = new HashMap<String, String>();
        }
        if (this.userMetadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.userMetadata.put(key, value);
        return this;
    }

    public S3Location clearUserMetadataEntries() {
        this.userMetadata = null;
        return this;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public S3Location withStorageClass(String storageClass) {
        this.setStorageClass(storageClass);
        return this;
    }

    public S3Location withStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketName() != null) {
            sb.append("BucketName: ").append(this.getBucketName()).append(",");
        }
        if (this.getPrefix() != null) {
            sb.append("Prefix: ").append(this.getPrefix()).append(",");
        }
        if (this.getEncryption() != null) {
            sb.append("Encryption: ").append(this.getEncryption()).append(",");
        }
        if (this.getCannedACL() != null) {
            sb.append("CannedACL: ").append(this.getCannedACL()).append(",");
        }
        if (this.getAccessControlList() != null) {
            sb.append("AccessControlList: ").append(this.getAccessControlList()).append(",");
        }
        if (this.getTagging() != null) {
            sb.append("Tagging: ").append(this.getTagging()).append(",");
        }
        if (this.getUserMetadata() != null) {
            sb.append("UserMetadata: ").append(this.getUserMetadata()).append(",");
        }
        if (this.getStorageClass() != null) {
            sb.append("StorageClass: ").append(this.getStorageClass());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Location)) {
            return false;
        }
        S3Location other = (S3Location)obj;
        if (other.getBucketName() == null ^ this.getBucketName() == null) {
            return false;
        }
        if (other.getBucketName() != null && !other.getBucketName().equals(this.getBucketName())) {
            return false;
        }
        if (other.getPrefix() == null ^ this.getPrefix() == null) {
            return false;
        }
        if (other.getPrefix() != null && !other.getPrefix().equals(this.getPrefix())) {
            return false;
        }
        if (other.getEncryption() == null ^ this.getEncryption() == null) {
            return false;
        }
        if (other.getEncryption() != null && !other.getEncryption().equals(this.getEncryption())) {
            return false;
        }
        if (other.getCannedACL() == null ^ this.getCannedACL() == null) {
            return false;
        }
        if (other.getCannedACL() != null && !other.getCannedACL().equals(this.getCannedACL())) {
            return false;
        }
        if (other.getAccessControlList() == null ^ this.getAccessControlList() == null) {
            return false;
        }
        if (other.getAccessControlList() != null && !other.getAccessControlList().equals(this.getAccessControlList())) {
            return false;
        }
        if (other.getTagging() == null ^ this.getTagging() == null) {
            return false;
        }
        if (other.getTagging() != null && !other.getTagging().equals(this.getTagging())) {
            return false;
        }
        if (other.getUserMetadata() == null ^ this.getUserMetadata() == null) {
            return false;
        }
        if (other.getUserMetadata() != null && !other.getUserMetadata().equals(this.getUserMetadata())) {
            return false;
        }
        if (other.getStorageClass() == null ^ this.getStorageClass() == null) {
            return false;
        }
        return other.getStorageClass() == null || other.getStorageClass().equals(this.getStorageClass());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketName() == null ? 0 : this.getBucketName().hashCode());
        hashCode = 31 * hashCode + (this.getPrefix() == null ? 0 : this.getPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getEncryption() == null ? 0 : this.getEncryption().hashCode());
        hashCode = 31 * hashCode + (this.getCannedACL() == null ? 0 : this.getCannedACL().hashCode());
        hashCode = 31 * hashCode + (this.getAccessControlList() == null ? 0 : this.getAccessControlList().hashCode());
        hashCode = 31 * hashCode + (this.getTagging() == null ? 0 : this.getTagging().hashCode());
        hashCode = 31 * hashCode + (this.getUserMetadata() == null ? 0 : this.getUserMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getStorageClass() == null ? 0 : this.getStorageClass().hashCode());
        return hashCode;
    }

    public S3Location clone() {
        try {
            return (S3Location)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3LocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

