/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreditSpecificationRequest;
import com.amazonaws.services.ec2.model.ElasticGpuSpecification;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.LaunchTemplateBlockDeviceMappingRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateInstanceMarketOptionsRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplatePlacementRequest;
import com.amazonaws.services.ec2.model.LaunchTemplateTagSpecificationRequest;
import com.amazonaws.services.ec2.model.LaunchTemplatesMonitoringRequest;
import com.amazonaws.services.ec2.model.ShutdownBehavior;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RequestLaunchTemplateData
implements Serializable,
Cloneable {
    private String kernelId;
    private Boolean ebsOptimized;
    private LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile;
    private SdkInternalList<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings;
    private SdkInternalList<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces;
    private String imageId;
    private String instanceType;
    private String keyName;
    private LaunchTemplatesMonitoringRequest monitoring;
    private LaunchTemplatePlacementRequest placement;
    private String ramDiskId;
    private Boolean disableApiTermination;
    private String instanceInitiatedShutdownBehavior;
    private String userData;
    private SdkInternalList<LaunchTemplateTagSpecificationRequest> tagSpecifications;
    private SdkInternalList<ElasticGpuSpecification> elasticGpuSpecifications;
    private SdkInternalList<String> securityGroupIds;
    private SdkInternalList<String> securityGroups;
    private LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions;
    private CreditSpecificationRequest creditSpecification;

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public RequestLaunchTemplateData withKernelId(String kernelId) {
        this.setKernelId(kernelId);
        return this;
    }

    public void setEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
    }

    public Boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    public RequestLaunchTemplateData withEbsOptimized(Boolean ebsOptimized) {
        this.setEbsOptimized(ebsOptimized);
        return this;
    }

    public Boolean isEbsOptimized() {
        return this.ebsOptimized;
    }

    public void setIamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile) {
        this.iamInstanceProfile = iamInstanceProfile;
    }

    public LaunchTemplateIamInstanceProfileSpecificationRequest getIamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public RequestLaunchTemplateData withIamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile) {
        this.setIamInstanceProfile(iamInstanceProfile);
        return this;
    }

    public List<LaunchTemplateBlockDeviceMappingRequest> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new SdkInternalList();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        this.blockDeviceMappings = new SdkInternalList<LaunchTemplateBlockDeviceMappingRequest>(blockDeviceMappings);
    }

    public RequestLaunchTemplateData withBlockDeviceMappings(LaunchTemplateBlockDeviceMappingRequest ... blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.setBlockDeviceMappings(new SdkInternalList<LaunchTemplateBlockDeviceMappingRequest>(blockDeviceMappings.length));
        }
        for (LaunchTemplateBlockDeviceMappingRequest ele : blockDeviceMappings) {
            this.blockDeviceMappings.add(ele);
        }
        return this;
    }

    public RequestLaunchTemplateData withBlockDeviceMappings(Collection<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings) {
        this.setBlockDeviceMappings(blockDeviceMappings);
        return this;
    }

    public List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> getNetworkInterfaces() {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new SdkInternalList();
        }
        return this.networkInterfaces;
    }

    public void setNetworkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces) {
        if (networkInterfaces == null) {
            this.networkInterfaces = null;
            return;
        }
        this.networkInterfaces = new SdkInternalList<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>(networkInterfaces);
    }

    public RequestLaunchTemplateData withNetworkInterfaces(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest ... networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.setNetworkInterfaces(new SdkInternalList<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>(networkInterfaces.length));
        }
        for (LaunchTemplateInstanceNetworkInterfaceSpecificationRequest ele : networkInterfaces) {
            this.networkInterfaces.add(ele);
        }
        return this;
    }

    public RequestLaunchTemplateData withNetworkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces) {
        this.setNetworkInterfaces(networkInterfaces);
        return this;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public RequestLaunchTemplateData withImageId(String imageId) {
        this.setImageId(imageId);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public RequestLaunchTemplateData withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public RequestLaunchTemplateData withInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public RequestLaunchTemplateData withKeyName(String keyName) {
        this.setKeyName(keyName);
        return this;
    }

    public void setMonitoring(LaunchTemplatesMonitoringRequest monitoring) {
        this.monitoring = monitoring;
    }

    public LaunchTemplatesMonitoringRequest getMonitoring() {
        return this.monitoring;
    }

    public RequestLaunchTemplateData withMonitoring(LaunchTemplatesMonitoringRequest monitoring) {
        this.setMonitoring(monitoring);
        return this;
    }

    public void setPlacement(LaunchTemplatePlacementRequest placement) {
        this.placement = placement;
    }

    public LaunchTemplatePlacementRequest getPlacement() {
        return this.placement;
    }

    public RequestLaunchTemplateData withPlacement(LaunchTemplatePlacementRequest placement) {
        this.setPlacement(placement);
        return this;
    }

    public void setRamDiskId(String ramDiskId) {
        this.ramDiskId = ramDiskId;
    }

    public String getRamDiskId() {
        return this.ramDiskId;
    }

    public RequestLaunchTemplateData withRamDiskId(String ramDiskId) {
        this.setRamDiskId(ramDiskId);
        return this;
    }

    public void setDisableApiTermination(Boolean disableApiTermination) {
        this.disableApiTermination = disableApiTermination;
    }

    public Boolean getDisableApiTermination() {
        return this.disableApiTermination;
    }

    public RequestLaunchTemplateData withDisableApiTermination(Boolean disableApiTermination) {
        this.setDisableApiTermination(disableApiTermination);
        return this;
    }

    public Boolean isDisableApiTermination() {
        return this.disableApiTermination;
    }

    public void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
        this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
    }

    public String getInstanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public RequestLaunchTemplateData withInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
        this.setInstanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior);
        return this;
    }

    public RequestLaunchTemplateData withInstanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
        this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior.toString();
        return this;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public String getUserData() {
        return this.userData;
    }

    public RequestLaunchTemplateData withUserData(String userData) {
        this.setUserData(userData);
        return this;
    }

    public List<LaunchTemplateTagSpecificationRequest> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<LaunchTemplateTagSpecificationRequest> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList<LaunchTemplateTagSpecificationRequest>(tagSpecifications);
    }

    public RequestLaunchTemplateData withTagSpecifications(LaunchTemplateTagSpecificationRequest ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications(new SdkInternalList<LaunchTemplateTagSpecificationRequest>(tagSpecifications.length));
        }
        for (LaunchTemplateTagSpecificationRequest ele : tagSpecifications) {
            this.tagSpecifications.add(ele);
        }
        return this;
    }

    public RequestLaunchTemplateData withTagSpecifications(Collection<LaunchTemplateTagSpecificationRequest> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    public List<ElasticGpuSpecification> getElasticGpuSpecifications() {
        if (this.elasticGpuSpecifications == null) {
            this.elasticGpuSpecifications = new SdkInternalList();
        }
        return this.elasticGpuSpecifications;
    }

    public void setElasticGpuSpecifications(Collection<ElasticGpuSpecification> elasticGpuSpecifications) {
        if (elasticGpuSpecifications == null) {
            this.elasticGpuSpecifications = null;
            return;
        }
        this.elasticGpuSpecifications = new SdkInternalList<ElasticGpuSpecification>(elasticGpuSpecifications);
    }

    public RequestLaunchTemplateData withElasticGpuSpecifications(ElasticGpuSpecification ... elasticGpuSpecifications) {
        if (this.elasticGpuSpecifications == null) {
            this.setElasticGpuSpecifications(new SdkInternalList<ElasticGpuSpecification>(elasticGpuSpecifications.length));
        }
        for (ElasticGpuSpecification ele : elasticGpuSpecifications) {
            this.elasticGpuSpecifications.add(ele);
        }
        return this;
    }

    public RequestLaunchTemplateData withElasticGpuSpecifications(Collection<ElasticGpuSpecification> elasticGpuSpecifications) {
        this.setElasticGpuSpecifications(elasticGpuSpecifications);
        return this;
    }

    public List<String> getSecurityGroupIds() {
        if (this.securityGroupIds == null) {
            this.securityGroupIds = new SdkInternalList();
        }
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        this.securityGroupIds = new SdkInternalList<String>(securityGroupIds);
    }

    public RequestLaunchTemplateData withSecurityGroupIds(String ... securityGroupIds) {
        if (this.securityGroupIds == null) {
            this.setSecurityGroupIds(new SdkInternalList<String>(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add(ele);
        }
        return this;
    }

    public RequestLaunchTemplateData withSecurityGroupIds(Collection<String> securityGroupIds) {
        this.setSecurityGroupIds(securityGroupIds);
        return this;
    }

    public List<String> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new SdkInternalList();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new SdkInternalList<String>(securityGroups);
    }

    public RequestLaunchTemplateData withSecurityGroups(String ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups(new SdkInternalList<String>(securityGroups.length));
        }
        for (String ele : securityGroups) {
            this.securityGroups.add(ele);
        }
        return this;
    }

    public RequestLaunchTemplateData withSecurityGroups(Collection<String> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public void setInstanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions) {
        this.instanceMarketOptions = instanceMarketOptions;
    }

    public LaunchTemplateInstanceMarketOptionsRequest getInstanceMarketOptions() {
        return this.instanceMarketOptions;
    }

    public RequestLaunchTemplateData withInstanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions) {
        this.setInstanceMarketOptions(instanceMarketOptions);
        return this;
    }

    public void setCreditSpecification(CreditSpecificationRequest creditSpecification) {
        this.creditSpecification = creditSpecification;
    }

    public CreditSpecificationRequest getCreditSpecification() {
        return this.creditSpecification;
    }

    public RequestLaunchTemplateData withCreditSpecification(CreditSpecificationRequest creditSpecification) {
        this.setCreditSpecification(creditSpecification);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKernelId() != null) {
            sb.append("KernelId: ").append(this.getKernelId()).append(",");
        }
        if (this.getEbsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.getEbsOptimized()).append(",");
        }
        if (this.getIamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(this.getIamInstanceProfile()).append(",");
        }
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.getBlockDeviceMappings()).append(",");
        }
        if (this.getNetworkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(this.getNetworkInterfaces()).append(",");
        }
        if (this.getImageId() != null) {
            sb.append("ImageId: ").append(this.getImageId()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getKeyName() != null) {
            sb.append("KeyName: ").append(this.getKeyName()).append(",");
        }
        if (this.getMonitoring() != null) {
            sb.append("Monitoring: ").append(this.getMonitoring()).append(",");
        }
        if (this.getPlacement() != null) {
            sb.append("Placement: ").append(this.getPlacement()).append(",");
        }
        if (this.getRamDiskId() != null) {
            sb.append("RamDiskId: ").append(this.getRamDiskId()).append(",");
        }
        if (this.getDisableApiTermination() != null) {
            sb.append("DisableApiTermination: ").append(this.getDisableApiTermination()).append(",");
        }
        if (this.getInstanceInitiatedShutdownBehavior() != null) {
            sb.append("InstanceInitiatedShutdownBehavior: ").append(this.getInstanceInitiatedShutdownBehavior()).append(",");
        }
        if (this.getUserData() != null) {
            sb.append("UserData: ").append(this.getUserData()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications()).append(",");
        }
        if (this.getElasticGpuSpecifications() != null) {
            sb.append("ElasticGpuSpecifications: ").append(this.getElasticGpuSpecifications()).append(",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.getSecurityGroupIds()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups()).append(",");
        }
        if (this.getInstanceMarketOptions() != null) {
            sb.append("InstanceMarketOptions: ").append(this.getInstanceMarketOptions()).append(",");
        }
        if (this.getCreditSpecification() != null) {
            sb.append("CreditSpecification: ").append(this.getCreditSpecification());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestLaunchTemplateData)) {
            return false;
        }
        RequestLaunchTemplateData other = (RequestLaunchTemplateData)obj;
        if (other.getKernelId() == null ^ this.getKernelId() == null) {
            return false;
        }
        if (other.getKernelId() != null && !other.getKernelId().equals(this.getKernelId())) {
            return false;
        }
        if (other.getEbsOptimized() == null ^ this.getEbsOptimized() == null) {
            return false;
        }
        if (other.getEbsOptimized() != null && !other.getEbsOptimized().equals(this.getEbsOptimized())) {
            return false;
        }
        if (other.getIamInstanceProfile() == null ^ this.getIamInstanceProfile() == null) {
            return false;
        }
        if (other.getIamInstanceProfile() != null && !other.getIamInstanceProfile().equals(this.getIamInstanceProfile())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getNetworkInterfaces() == null ^ this.getNetworkInterfaces() == null) {
            return false;
        }
        if (other.getNetworkInterfaces() != null && !other.getNetworkInterfaces().equals(this.getNetworkInterfaces())) {
            return false;
        }
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getKeyName() == null ^ this.getKeyName() == null) {
            return false;
        }
        if (other.getKeyName() != null && !other.getKeyName().equals(this.getKeyName())) {
            return false;
        }
        if (other.getMonitoring() == null ^ this.getMonitoring() == null) {
            return false;
        }
        if (other.getMonitoring() != null && !other.getMonitoring().equals(this.getMonitoring())) {
            return false;
        }
        if (other.getPlacement() == null ^ this.getPlacement() == null) {
            return false;
        }
        if (other.getPlacement() != null && !other.getPlacement().equals(this.getPlacement())) {
            return false;
        }
        if (other.getRamDiskId() == null ^ this.getRamDiskId() == null) {
            return false;
        }
        if (other.getRamDiskId() != null && !other.getRamDiskId().equals(this.getRamDiskId())) {
            return false;
        }
        if (other.getDisableApiTermination() == null ^ this.getDisableApiTermination() == null) {
            return false;
        }
        if (other.getDisableApiTermination() != null && !other.getDisableApiTermination().equals(this.getDisableApiTermination())) {
            return false;
        }
        if (other.getInstanceInitiatedShutdownBehavior() == null ^ this.getInstanceInitiatedShutdownBehavior() == null) {
            return false;
        }
        if (other.getInstanceInitiatedShutdownBehavior() != null && !other.getInstanceInitiatedShutdownBehavior().equals(this.getInstanceInitiatedShutdownBehavior())) {
            return false;
        }
        if (other.getUserData() == null ^ this.getUserData() == null) {
            return false;
        }
        if (other.getUserData() != null && !other.getUserData().equals(this.getUserData())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        if (other.getTagSpecifications() != null && !other.getTagSpecifications().equals(this.getTagSpecifications())) {
            return false;
        }
        if (other.getElasticGpuSpecifications() == null ^ this.getElasticGpuSpecifications() == null) {
            return false;
        }
        if (other.getElasticGpuSpecifications() != null && !other.getElasticGpuSpecifications().equals(this.getElasticGpuSpecifications())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        if (other.getSecurityGroupIds() != null && !other.getSecurityGroupIds().equals(this.getSecurityGroupIds())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getInstanceMarketOptions() == null ^ this.getInstanceMarketOptions() == null) {
            return false;
        }
        if (other.getInstanceMarketOptions() != null && !other.getInstanceMarketOptions().equals(this.getInstanceMarketOptions())) {
            return false;
        }
        if (other.getCreditSpecification() == null ^ this.getCreditSpecification() == null) {
            return false;
        }
        return other.getCreditSpecification() == null || other.getCreditSpecification().equals(this.getCreditSpecification());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKernelId() == null ? 0 : this.getKernelId().hashCode());
        hashCode = 31 * hashCode + (this.getEbsOptimized() == null ? 0 : this.getEbsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.getIamInstanceProfile() == null ? 0 : this.getIamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInterfaces() == null ? 0 : this.getNetworkInterfaces().hashCode());
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getKeyName() == null ? 0 : this.getKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoring() == null ? 0 : this.getMonitoring().hashCode());
        hashCode = 31 * hashCode + (this.getPlacement() == null ? 0 : this.getPlacement().hashCode());
        hashCode = 31 * hashCode + (this.getRamDiskId() == null ? 0 : this.getRamDiskId().hashCode());
        hashCode = 31 * hashCode + (this.getDisableApiTermination() == null ? 0 : this.getDisableApiTermination().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceInitiatedShutdownBehavior() == null ? 0 : this.getInstanceInitiatedShutdownBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getUserData() == null ? 0 : this.getUserData().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getElasticGpuSpecifications() == null ? 0 : this.getElasticGpuSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceMarketOptions() == null ? 0 : this.getInstanceMarketOptions().hashCode());
        hashCode = 31 * hashCode + (this.getCreditSpecification() == null ? 0 : this.getCreditSpecification().hashCode());
        return hashCode;
    }

    public RequestLaunchTemplateData clone() {
        try {
            return (RequestLaunchTemplateData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

