/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model.transform;

import com.amazonaws.services.comprehend.model.Entity;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class EntityJsonUnmarshaller
implements Unmarshaller<Entity, JsonUnmarshallerContext> {
    private static EntityJsonUnmarshaller instance;

    @Override
    public Entity unmarshall(JsonUnmarshallerContext context) throws Exception {
        Entity entity = new Entity();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Score", targetDepth)) {
                    context.nextToken();
                    entity.setScore(context.getUnmarshaller(Float.class).unmarshall(context));
                }
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    entity.setType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Text", targetDepth)) {
                    context.nextToken();
                    entity.setText(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("BeginOffset", targetDepth)) {
                    context.nextToken();
                    entity.setBeginOffset(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("EndOffset", targetDepth)) {
                    context.nextToken();
                    entity.setEndOffset(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return entity;
    }

    public static EntityJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EntityJsonUnmarshaller();
        }
        return instance;
    }
}

