/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.services.route53.model.ChangeBatch;
import com.amazonaws.services.route53.model.transform.ChangeStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ChangeBatchStaxUnmarshaller
implements Unmarshaller<ChangeBatch, StaxUnmarshallerContext> {
    private static ChangeBatchStaxUnmarshaller instance;

    @Override
    public ChangeBatch unmarshall(StaxUnmarshallerContext context) throws Exception {
        ChangeBatch changeBatch = new ChangeBatch();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return changeBatch;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Comment", targetDepth)) {
                    changeBatch.setComment(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Changes/Change", targetDepth)) continue;
                changeBatch.withChanges(ChangeStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return changeBatch;
    }

    public static ChangeBatchStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ChangeBatchStaxUnmarshaller();
        }
        return instance;
    }
}

