/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.waiters.DescribeStreamFunction;
import com.amazonaws.services.kinesis.waiters.StreamExists;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonKinesisWaiters {
    private final AmazonKinesis client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonKinesisWaiters(AmazonKinesis client) {
        this.client = client;
    }

    public Waiter streamExists() {
        return new WaiterBuilder<DescribeStreamRequest, DescribeStreamResult>().withSdkFunction(new DescribeStreamFunction(this.client)).withAcceptors(new StreamExists.IsACTIVEMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(18), new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }
}

