/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.waiters.DescribeStacksFunction;
import com.amazonaws.services.cloudformation.waiters.StackCreateComplete;
import com.amazonaws.services.cloudformation.waiters.StackDeleteComplete;
import com.amazonaws.services.cloudformation.waiters.StackExists;
import com.amazonaws.services.cloudformation.waiters.StackUpdateComplete;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.HttpSuccessStatusAcceptor;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterState;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonCloudFormationWaiters {
    private final AmazonCloudFormation client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonCloudFormationWaiters(AmazonCloudFormation client) {
        this.client = client;
    }

    public Waiter stackExists() {
        return new WaiterBuilder<DescribeStacksRequest, DescribeStacksResult>().withSdkFunction(new DescribeStacksFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new StackExists.IsValidationErrorMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter stackCreateComplete() {
        return new WaiterBuilder<DescribeStacksRequest, DescribeStacksResult>().withSdkFunction(new DescribeStacksFunction(this.client)).withAcceptors(new StackCreateComplete.IsCREATE_COMPLETEMatcher(), new StackCreateComplete.IsCREATE_FAILEDMatcher(), new StackCreateComplete.IsDELETE_COMPLETEMatcher(), new StackCreateComplete.IsDELETE_IN_PROGRESSMatcher(), new StackCreateComplete.IsDELETE_FAILEDMatcher(), new StackCreateComplete.IsROLLBACK_COMPLETEMatcher(), new StackCreateComplete.IsROLLBACK_FAILEDMatcher(), new StackCreateComplete.IsROLLBACK_IN_PROGRESSMatcher(), new StackCreateComplete.IsValidationErrorMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(120), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter stackDeleteComplete() {
        return new WaiterBuilder<DescribeStacksRequest, DescribeStacksResult>().withSdkFunction(new DescribeStacksFunction(this.client)).withAcceptors(new StackDeleteComplete.IsDELETE_COMPLETEMatcher(), new StackDeleteComplete.IsValidationErrorMatcher(), new StackDeleteComplete.IsDELETE_FAILEDMatcher(), new StackDeleteComplete.IsCREATE_COMPLETEMatcher(), new StackDeleteComplete.IsCREATE_FAILEDMatcher(), new StackDeleteComplete.IsCREATE_IN_PROGRESSMatcher(), new StackDeleteComplete.IsROLLBACK_COMPLETEMatcher(), new StackDeleteComplete.IsROLLBACK_FAILEDMatcher(), new StackDeleteComplete.IsROLLBACK_IN_PROGRESSMatcher(), new StackDeleteComplete.IsUPDATE_COMPLETEMatcher(), new StackDeleteComplete.IsUPDATE_COMPLETE_CLEANUP_IN_PROGRESSMatcher(), new StackDeleteComplete.IsUPDATE_IN_PROGRESSMatcher(), new StackDeleteComplete.IsUPDATE_ROLLBACK_COMPLETEMatcher(), new StackDeleteComplete.IsUPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESSMatcher(), new StackDeleteComplete.IsUPDATE_ROLLBACK_FAILEDMatcher(), new StackDeleteComplete.IsUPDATE_ROLLBACK_IN_PROGRESSMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(120), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter stackUpdateComplete() {
        return new WaiterBuilder<DescribeStacksRequest, DescribeStacksResult>().withSdkFunction(new DescribeStacksFunction(this.client)).withAcceptors(new StackUpdateComplete.IsUPDATE_COMPLETEMatcher(), new StackUpdateComplete.IsUPDATE_FAILEDMatcher(), new StackUpdateComplete.IsUPDATE_ROLLBACK_COMPLETEMatcher(), new StackUpdateComplete.IsUPDATE_ROLLBACK_FAILEDMatcher(), new StackUpdateComplete.IsUPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESSMatcher(), new StackUpdateComplete.IsUPDATE_ROLLBACK_IN_PROGRESSMatcher(), new StackUpdateComplete.IsValidationErrorMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(120), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }
}

