/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteAssociationRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DeleteAssociationRequestMarshaller
implements Marshaller<Request<DeleteAssociationRequest>, DeleteAssociationRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteAssociationRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteAssociationRequest> marshall(DeleteAssociationRequest deleteAssociationRequest) {
        if (deleteAssociationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteAssociationRequest> request = new DefaultRequest<DeleteAssociationRequest>(deleteAssociationRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.DeleteAssociation");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteAssociationRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(deleteAssociationRequest.getName());
            }
            if (deleteAssociationRequest.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(deleteAssociationRequest.getInstanceId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

