/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model.transform;

import com.amazonaws.services.costexplorer.model.Expression;
import com.amazonaws.services.costexplorer.model.transform.DimensionValuesJsonUnmarshaller;
import com.amazonaws.services.costexplorer.model.transform.TagValuesJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class ExpressionJsonUnmarshaller
implements Unmarshaller<Expression, JsonUnmarshallerContext> {
    private static ExpressionJsonUnmarshaller instance;

    @Override
    public Expression unmarshall(JsonUnmarshallerContext context) throws Exception {
        Expression expression = new Expression();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Or", targetDepth)) {
                    context.nextToken();
                    expression.setOr(new ListUnmarshaller<Expression>(ExpressionJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("And", targetDepth)) {
                    context.nextToken();
                    expression.setAnd(new ListUnmarshaller<Expression>(ExpressionJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Not", targetDepth)) {
                    context.nextToken();
                    expression.setNot(ExpressionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Dimensions", targetDepth)) {
                    context.nextToken();
                    expression.setDimensions(DimensionValuesJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Tags", targetDepth)) {
                    context.nextToken();
                    expression.setTags(TagValuesJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return expression;
    }

    public static ExpressionJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ExpressionJsonUnmarshaller();
        }
        return instance;
    }
}

