/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeDBClusterParametersRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeDBClusterParametersRequestMarshaller
implements Marshaller<Request<DescribeDBClusterParametersRequest>, DescribeDBClusterParametersRequest> {
    @Override
    public Request<DescribeDBClusterParametersRequest> marshall(DescribeDBClusterParametersRequest describeDBClusterParametersRequest) {
        SdkInternalList filtersList;
        if (describeDBClusterParametersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeDBClusterParametersRequest> request = new DefaultRequest<DescribeDBClusterParametersRequest>(describeDBClusterParametersRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeDBClusterParameters");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBClusterParametersRequest.getDBClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString(describeDBClusterParametersRequest.getDBClusterParameterGroupName()));
        }
        if (describeDBClusterParametersRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString(describeDBClusterParametersRequest.getSource()));
        }
        if (!(filtersList = (SdkInternalList)describeDBClusterParametersRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString(filtersListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDBClusterParametersRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeDBClusterParametersRequest.getMaxRecords()));
        }
        if (describeDBClusterParametersRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeDBClusterParametersRequest.getMarker()));
        }
        return request;
    }
}

