/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DoubleRange;
import com.amazonaws.services.rds.model.Range;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ValidStorageOptions
implements Serializable,
Cloneable {
    private String storageType;
    private SdkInternalList<Range> storageSize;
    private SdkInternalList<Range> provisionedIops;
    private SdkInternalList<DoubleRange> iopsToStorageRatio;

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public ValidStorageOptions withStorageType(String storageType) {
        this.setStorageType(storageType);
        return this;
    }

    public List<Range> getStorageSize() {
        if (this.storageSize == null) {
            this.storageSize = new SdkInternalList();
        }
        return this.storageSize;
    }

    public void setStorageSize(Collection<Range> storageSize) {
        if (storageSize == null) {
            this.storageSize = null;
            return;
        }
        this.storageSize = new SdkInternalList<Range>(storageSize);
    }

    public ValidStorageOptions withStorageSize(Range ... storageSize) {
        if (this.storageSize == null) {
            this.setStorageSize(new SdkInternalList<Range>(storageSize.length));
        }
        for (Range ele : storageSize) {
            this.storageSize.add(ele);
        }
        return this;
    }

    public ValidStorageOptions withStorageSize(Collection<Range> storageSize) {
        this.setStorageSize(storageSize);
        return this;
    }

    public List<Range> getProvisionedIops() {
        if (this.provisionedIops == null) {
            this.provisionedIops = new SdkInternalList();
        }
        return this.provisionedIops;
    }

    public void setProvisionedIops(Collection<Range> provisionedIops) {
        if (provisionedIops == null) {
            this.provisionedIops = null;
            return;
        }
        this.provisionedIops = new SdkInternalList<Range>(provisionedIops);
    }

    public ValidStorageOptions withProvisionedIops(Range ... provisionedIops) {
        if (this.provisionedIops == null) {
            this.setProvisionedIops(new SdkInternalList<Range>(provisionedIops.length));
        }
        for (Range ele : provisionedIops) {
            this.provisionedIops.add(ele);
        }
        return this;
    }

    public ValidStorageOptions withProvisionedIops(Collection<Range> provisionedIops) {
        this.setProvisionedIops(provisionedIops);
        return this;
    }

    public List<DoubleRange> getIopsToStorageRatio() {
        if (this.iopsToStorageRatio == null) {
            this.iopsToStorageRatio = new SdkInternalList();
        }
        return this.iopsToStorageRatio;
    }

    public void setIopsToStorageRatio(Collection<DoubleRange> iopsToStorageRatio) {
        if (iopsToStorageRatio == null) {
            this.iopsToStorageRatio = null;
            return;
        }
        this.iopsToStorageRatio = new SdkInternalList<DoubleRange>(iopsToStorageRatio);
    }

    public ValidStorageOptions withIopsToStorageRatio(DoubleRange ... iopsToStorageRatio) {
        if (this.iopsToStorageRatio == null) {
            this.setIopsToStorageRatio(new SdkInternalList<DoubleRange>(iopsToStorageRatio.length));
        }
        for (DoubleRange ele : iopsToStorageRatio) {
            this.iopsToStorageRatio.add(ele);
        }
        return this;
    }

    public ValidStorageOptions withIopsToStorageRatio(Collection<DoubleRange> iopsToStorageRatio) {
        this.setIopsToStorageRatio(iopsToStorageRatio);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStorageType() != null) {
            sb.append("StorageType: ").append(this.getStorageType()).append(",");
        }
        if (this.getStorageSize() != null) {
            sb.append("StorageSize: ").append(this.getStorageSize()).append(",");
        }
        if (this.getProvisionedIops() != null) {
            sb.append("ProvisionedIops: ").append(this.getProvisionedIops()).append(",");
        }
        if (this.getIopsToStorageRatio() != null) {
            sb.append("IopsToStorageRatio: ").append(this.getIopsToStorageRatio());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidStorageOptions)) {
            return false;
        }
        ValidStorageOptions other = (ValidStorageOptions)obj;
        if (other.getStorageType() == null ^ this.getStorageType() == null) {
            return false;
        }
        if (other.getStorageType() != null && !other.getStorageType().equals(this.getStorageType())) {
            return false;
        }
        if (other.getStorageSize() == null ^ this.getStorageSize() == null) {
            return false;
        }
        if (other.getStorageSize() != null && !other.getStorageSize().equals(this.getStorageSize())) {
            return false;
        }
        if (other.getProvisionedIops() == null ^ this.getProvisionedIops() == null) {
            return false;
        }
        if (other.getProvisionedIops() != null && !other.getProvisionedIops().equals(this.getProvisionedIops())) {
            return false;
        }
        if (other.getIopsToStorageRatio() == null ^ this.getIopsToStorageRatio() == null) {
            return false;
        }
        return other.getIopsToStorageRatio() == null || other.getIopsToStorageRatio().equals(this.getIopsToStorageRatio());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStorageType() == null ? 0 : this.getStorageType().hashCode());
        hashCode = 31 * hashCode + (this.getStorageSize() == null ? 0 : this.getStorageSize().hashCode());
        hashCode = 31 * hashCode + (this.getProvisionedIops() == null ? 0 : this.getProvisionedIops().hashCode());
        hashCode = 31 * hashCode + (this.getIopsToStorageRatio() == null ? 0 : this.getIopsToStorageRatio().hashCode());
        return hashCode;
    }

    public ValidStorageOptions clone() {
        try {
            return (ValidStorageOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

