/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DescribeEnvironmentsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationName;
    private String versionLabel;
    private SdkInternalList<String> environmentIds;
    private SdkInternalList<String> environmentNames;
    private Boolean includeDeleted;
    private Date includedDeletedBackTo;
    private Integer maxRecords;
    private String nextToken;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public DescribeEnvironmentsRequest withApplicationName(String applicationName) {
        this.setApplicationName(applicationName);
        return this;
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public DescribeEnvironmentsRequest withVersionLabel(String versionLabel) {
        this.setVersionLabel(versionLabel);
        return this;
    }

    public List<String> getEnvironmentIds() {
        if (this.environmentIds == null) {
            this.environmentIds = new SdkInternalList();
        }
        return this.environmentIds;
    }

    public void setEnvironmentIds(Collection<String> environmentIds) {
        if (environmentIds == null) {
            this.environmentIds = null;
            return;
        }
        this.environmentIds = new SdkInternalList<String>(environmentIds);
    }

    public DescribeEnvironmentsRequest withEnvironmentIds(String ... environmentIds) {
        if (this.environmentIds == null) {
            this.setEnvironmentIds(new SdkInternalList<String>(environmentIds.length));
        }
        for (String ele : environmentIds) {
            this.environmentIds.add(ele);
        }
        return this;
    }

    public DescribeEnvironmentsRequest withEnvironmentIds(Collection<String> environmentIds) {
        this.setEnvironmentIds(environmentIds);
        return this;
    }

    public List<String> getEnvironmentNames() {
        if (this.environmentNames == null) {
            this.environmentNames = new SdkInternalList();
        }
        return this.environmentNames;
    }

    public void setEnvironmentNames(Collection<String> environmentNames) {
        if (environmentNames == null) {
            this.environmentNames = null;
            return;
        }
        this.environmentNames = new SdkInternalList<String>(environmentNames);
    }

    public DescribeEnvironmentsRequest withEnvironmentNames(String ... environmentNames) {
        if (this.environmentNames == null) {
            this.setEnvironmentNames(new SdkInternalList<String>(environmentNames.length));
        }
        for (String ele : environmentNames) {
            this.environmentNames.add(ele);
        }
        return this;
    }

    public DescribeEnvironmentsRequest withEnvironmentNames(Collection<String> environmentNames) {
        this.setEnvironmentNames(environmentNames);
        return this;
    }

    public void setIncludeDeleted(Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
    }

    public Boolean getIncludeDeleted() {
        return this.includeDeleted;
    }

    public DescribeEnvironmentsRequest withIncludeDeleted(Boolean includeDeleted) {
        this.setIncludeDeleted(includeDeleted);
        return this;
    }

    public Boolean isIncludeDeleted() {
        return this.includeDeleted;
    }

    public void setIncludedDeletedBackTo(Date includedDeletedBackTo) {
        this.includedDeletedBackTo = includedDeletedBackTo;
    }

    public Date getIncludedDeletedBackTo() {
        return this.includedDeletedBackTo;
    }

    public DescribeEnvironmentsRequest withIncludedDeletedBackTo(Date includedDeletedBackTo) {
        this.setIncludedDeletedBackTo(includedDeletedBackTo);
        return this;
    }

    public void setMaxRecords(Integer maxRecords) {
        this.maxRecords = maxRecords;
    }

    public Integer getMaxRecords() {
        return this.maxRecords;
    }

    public DescribeEnvironmentsRequest withMaxRecords(Integer maxRecords) {
        this.setMaxRecords(maxRecords);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeEnvironmentsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: ").append(this.getApplicationName()).append(",");
        }
        if (this.getVersionLabel() != null) {
            sb.append("VersionLabel: ").append(this.getVersionLabel()).append(",");
        }
        if (this.getEnvironmentIds() != null) {
            sb.append("EnvironmentIds: ").append(this.getEnvironmentIds()).append(",");
        }
        if (this.getEnvironmentNames() != null) {
            sb.append("EnvironmentNames: ").append(this.getEnvironmentNames()).append(",");
        }
        if (this.getIncludeDeleted() != null) {
            sb.append("IncludeDeleted: ").append(this.getIncludeDeleted()).append(",");
        }
        if (this.getIncludedDeletedBackTo() != null) {
            sb.append("IncludedDeletedBackTo: ").append(this.getIncludedDeletedBackTo()).append(",");
        }
        if (this.getMaxRecords() != null) {
            sb.append("MaxRecords: ").append(this.getMaxRecords()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentsRequest)) {
            return false;
        }
        DescribeEnvironmentsRequest other = (DescribeEnvironmentsRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getVersionLabel() == null ^ this.getVersionLabel() == null) {
            return false;
        }
        if (other.getVersionLabel() != null && !other.getVersionLabel().equals(this.getVersionLabel())) {
            return false;
        }
        if (other.getEnvironmentIds() == null ^ this.getEnvironmentIds() == null) {
            return false;
        }
        if (other.getEnvironmentIds() != null && !other.getEnvironmentIds().equals(this.getEnvironmentIds())) {
            return false;
        }
        if (other.getEnvironmentNames() == null ^ this.getEnvironmentNames() == null) {
            return false;
        }
        if (other.getEnvironmentNames() != null && !other.getEnvironmentNames().equals(this.getEnvironmentNames())) {
            return false;
        }
        if (other.getIncludeDeleted() == null ^ this.getIncludeDeleted() == null) {
            return false;
        }
        if (other.getIncludeDeleted() != null && !other.getIncludeDeleted().equals(this.getIncludeDeleted())) {
            return false;
        }
        if (other.getIncludedDeletedBackTo() == null ^ this.getIncludedDeletedBackTo() == null) {
            return false;
        }
        if (other.getIncludedDeletedBackTo() != null && !other.getIncludedDeletedBackTo().equals(this.getIncludedDeletedBackTo())) {
            return false;
        }
        if (other.getMaxRecords() == null ^ this.getMaxRecords() == null) {
            return false;
        }
        if (other.getMaxRecords() != null && !other.getMaxRecords().equals(this.getMaxRecords())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getVersionLabel() == null ? 0 : this.getVersionLabel().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentIds() == null ? 0 : this.getEnvironmentIds().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentNames() == null ? 0 : this.getEnvironmentNames().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeDeleted() == null ? 0 : this.getIncludeDeleted().hashCode());
        hashCode = 31 * hashCode + (this.getIncludedDeletedBackTo() == null ? 0 : this.getIncludedDeletedBackTo().hashCode());
        hashCode = 31 * hashCode + (this.getMaxRecords() == null ? 0 : this.getMaxRecords().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public DescribeEnvironmentsRequest clone() {
        return (DescribeEnvironmentsRequest)super.clone();
    }
}

