/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53.model.AlarmIdentifier;
import com.amazonaws.services.route53.model.HealthCheckRegion;
import com.amazonaws.services.route53.model.HealthCheckType;
import com.amazonaws.services.route53.model.InsufficientDataHealthStatus;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class HealthCheckConfig
implements Serializable,
Cloneable {
    private String iPAddress;
    private Integer port;
    private String type;
    private String resourcePath;
    private String fullyQualifiedDomainName;
    private String searchString;
    private Integer requestInterval;
    private Integer failureThreshold;
    private Boolean measureLatency;
    private Boolean inverted;
    private Integer healthThreshold;
    private SdkInternalList<String> childHealthChecks;
    private Boolean enableSNI;
    private SdkInternalList<String> regions;
    private AlarmIdentifier alarmIdentifier;
    private String insufficientDataHealthStatus;

    public void setIPAddress(String iPAddress) {
        this.iPAddress = iPAddress;
    }

    public String getIPAddress() {
        return this.iPAddress;
    }

    public HealthCheckConfig withIPAddress(String iPAddress) {
        this.setIPAddress(iPAddress);
        return this;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public HealthCheckConfig withPort(Integer port) {
        this.setPort(port);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public HealthCheckConfig withType(String type) {
        this.setType(type);
        return this;
    }

    public void setType(HealthCheckType type) {
        this.withType(type);
    }

    public HealthCheckConfig withType(HealthCheckType type) {
        this.type = type.toString();
        return this;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public HealthCheckConfig withResourcePath(String resourcePath) {
        this.setResourcePath(resourcePath);
        return this;
    }

    public void setFullyQualifiedDomainName(String fullyQualifiedDomainName) {
        this.fullyQualifiedDomainName = fullyQualifiedDomainName;
    }

    public String getFullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public HealthCheckConfig withFullyQualifiedDomainName(String fullyQualifiedDomainName) {
        this.setFullyQualifiedDomainName(fullyQualifiedDomainName);
        return this;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public HealthCheckConfig withSearchString(String searchString) {
        this.setSearchString(searchString);
        return this;
    }

    public void setRequestInterval(Integer requestInterval) {
        this.requestInterval = requestInterval;
    }

    public Integer getRequestInterval() {
        return this.requestInterval;
    }

    public HealthCheckConfig withRequestInterval(Integer requestInterval) {
        this.setRequestInterval(requestInterval);
        return this;
    }

    public void setFailureThreshold(Integer failureThreshold) {
        this.failureThreshold = failureThreshold;
    }

    public Integer getFailureThreshold() {
        return this.failureThreshold;
    }

    public HealthCheckConfig withFailureThreshold(Integer failureThreshold) {
        this.setFailureThreshold(failureThreshold);
        return this;
    }

    public void setMeasureLatency(Boolean measureLatency) {
        this.measureLatency = measureLatency;
    }

    public Boolean getMeasureLatency() {
        return this.measureLatency;
    }

    public HealthCheckConfig withMeasureLatency(Boolean measureLatency) {
        this.setMeasureLatency(measureLatency);
        return this;
    }

    public Boolean isMeasureLatency() {
        return this.measureLatency;
    }

    public void setInverted(Boolean inverted) {
        this.inverted = inverted;
    }

    public Boolean getInverted() {
        return this.inverted;
    }

    public HealthCheckConfig withInverted(Boolean inverted) {
        this.setInverted(inverted);
        return this;
    }

    public Boolean isInverted() {
        return this.inverted;
    }

    public void setHealthThreshold(Integer healthThreshold) {
        this.healthThreshold = healthThreshold;
    }

    public Integer getHealthThreshold() {
        return this.healthThreshold;
    }

    public HealthCheckConfig withHealthThreshold(Integer healthThreshold) {
        this.setHealthThreshold(healthThreshold);
        return this;
    }

    public List<String> getChildHealthChecks() {
        if (this.childHealthChecks == null) {
            this.childHealthChecks = new SdkInternalList();
        }
        return this.childHealthChecks;
    }

    public void setChildHealthChecks(Collection<String> childHealthChecks) {
        if (childHealthChecks == null) {
            this.childHealthChecks = null;
            return;
        }
        this.childHealthChecks = new SdkInternalList<String>(childHealthChecks);
    }

    public HealthCheckConfig withChildHealthChecks(String ... childHealthChecks) {
        if (this.childHealthChecks == null) {
            this.setChildHealthChecks(new SdkInternalList<String>(childHealthChecks.length));
        }
        for (String ele : childHealthChecks) {
            this.childHealthChecks.add(ele);
        }
        return this;
    }

    public HealthCheckConfig withChildHealthChecks(Collection<String> childHealthChecks) {
        this.setChildHealthChecks(childHealthChecks);
        return this;
    }

    public void setEnableSNI(Boolean enableSNI) {
        this.enableSNI = enableSNI;
    }

    public Boolean getEnableSNI() {
        return this.enableSNI;
    }

    public HealthCheckConfig withEnableSNI(Boolean enableSNI) {
        this.setEnableSNI(enableSNI);
        return this;
    }

    public Boolean isEnableSNI() {
        return this.enableSNI;
    }

    public List<String> getRegions() {
        if (this.regions == null) {
            this.regions = new SdkInternalList();
        }
        return this.regions;
    }

    public void setRegions(Collection<String> regions) {
        if (regions == null) {
            this.regions = null;
            return;
        }
        this.regions = new SdkInternalList<String>(regions);
    }

    public HealthCheckConfig withRegions(String ... regions) {
        if (this.regions == null) {
            this.setRegions(new SdkInternalList<String>(regions.length));
        }
        for (String ele : regions) {
            this.regions.add(ele);
        }
        return this;
    }

    public HealthCheckConfig withRegions(Collection<String> regions) {
        this.setRegions(regions);
        return this;
    }

    public HealthCheckConfig withRegions(HealthCheckRegion ... regions) {
        SdkInternalList<String> regionsCopy = new SdkInternalList<String>(regions.length);
        for (HealthCheckRegion value : regions) {
            regionsCopy.add(value.toString());
        }
        if (this.getRegions() == null) {
            this.setRegions(regionsCopy);
        } else {
            this.getRegions().addAll(regionsCopy);
        }
        return this;
    }

    public void setAlarmIdentifier(AlarmIdentifier alarmIdentifier) {
        this.alarmIdentifier = alarmIdentifier;
    }

    public AlarmIdentifier getAlarmIdentifier() {
        return this.alarmIdentifier;
    }

    public HealthCheckConfig withAlarmIdentifier(AlarmIdentifier alarmIdentifier) {
        this.setAlarmIdentifier(alarmIdentifier);
        return this;
    }

    public void setInsufficientDataHealthStatus(String insufficientDataHealthStatus) {
        this.insufficientDataHealthStatus = insufficientDataHealthStatus;
    }

    public String getInsufficientDataHealthStatus() {
        return this.insufficientDataHealthStatus;
    }

    public HealthCheckConfig withInsufficientDataHealthStatus(String insufficientDataHealthStatus) {
        this.setInsufficientDataHealthStatus(insufficientDataHealthStatus);
        return this;
    }

    public void setInsufficientDataHealthStatus(InsufficientDataHealthStatus insufficientDataHealthStatus) {
        this.withInsufficientDataHealthStatus(insufficientDataHealthStatus);
    }

    public HealthCheckConfig withInsufficientDataHealthStatus(InsufficientDataHealthStatus insufficientDataHealthStatus) {
        this.insufficientDataHealthStatus = insufficientDataHealthStatus.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIPAddress() != null) {
            sb.append("IPAddress: ").append(this.getIPAddress()).append(",");
        }
        if (this.getPort() != null) {
            sb.append("Port: ").append(this.getPort()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getResourcePath() != null) {
            sb.append("ResourcePath: ").append(this.getResourcePath()).append(",");
        }
        if (this.getFullyQualifiedDomainName() != null) {
            sb.append("FullyQualifiedDomainName: ").append(this.getFullyQualifiedDomainName()).append(",");
        }
        if (this.getSearchString() != null) {
            sb.append("SearchString: ").append(this.getSearchString()).append(",");
        }
        if (this.getRequestInterval() != null) {
            sb.append("RequestInterval: ").append(this.getRequestInterval()).append(",");
        }
        if (this.getFailureThreshold() != null) {
            sb.append("FailureThreshold: ").append(this.getFailureThreshold()).append(",");
        }
        if (this.getMeasureLatency() != null) {
            sb.append("MeasureLatency: ").append(this.getMeasureLatency()).append(",");
        }
        if (this.getInverted() != null) {
            sb.append("Inverted: ").append(this.getInverted()).append(",");
        }
        if (this.getHealthThreshold() != null) {
            sb.append("HealthThreshold: ").append(this.getHealthThreshold()).append(",");
        }
        if (this.getChildHealthChecks() != null) {
            sb.append("ChildHealthChecks: ").append(this.getChildHealthChecks()).append(",");
        }
        if (this.getEnableSNI() != null) {
            sb.append("EnableSNI: ").append(this.getEnableSNI()).append(",");
        }
        if (this.getRegions() != null) {
            sb.append("Regions: ").append(this.getRegions()).append(",");
        }
        if (this.getAlarmIdentifier() != null) {
            sb.append("AlarmIdentifier: ").append(this.getAlarmIdentifier()).append(",");
        }
        if (this.getInsufficientDataHealthStatus() != null) {
            sb.append("InsufficientDataHealthStatus: ").append(this.getInsufficientDataHealthStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckConfig)) {
            return false;
        }
        HealthCheckConfig other = (HealthCheckConfig)obj;
        if (other.getIPAddress() == null ^ this.getIPAddress() == null) {
            return false;
        }
        if (other.getIPAddress() != null && !other.getIPAddress().equals(this.getIPAddress())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getResourcePath() == null ^ this.getResourcePath() == null) {
            return false;
        }
        if (other.getResourcePath() != null && !other.getResourcePath().equals(this.getResourcePath())) {
            return false;
        }
        if (other.getFullyQualifiedDomainName() == null ^ this.getFullyQualifiedDomainName() == null) {
            return false;
        }
        if (other.getFullyQualifiedDomainName() != null && !other.getFullyQualifiedDomainName().equals(this.getFullyQualifiedDomainName())) {
            return false;
        }
        if (other.getSearchString() == null ^ this.getSearchString() == null) {
            return false;
        }
        if (other.getSearchString() != null && !other.getSearchString().equals(this.getSearchString())) {
            return false;
        }
        if (other.getRequestInterval() == null ^ this.getRequestInterval() == null) {
            return false;
        }
        if (other.getRequestInterval() != null && !other.getRequestInterval().equals(this.getRequestInterval())) {
            return false;
        }
        if (other.getFailureThreshold() == null ^ this.getFailureThreshold() == null) {
            return false;
        }
        if (other.getFailureThreshold() != null && !other.getFailureThreshold().equals(this.getFailureThreshold())) {
            return false;
        }
        if (other.getMeasureLatency() == null ^ this.getMeasureLatency() == null) {
            return false;
        }
        if (other.getMeasureLatency() != null && !other.getMeasureLatency().equals(this.getMeasureLatency())) {
            return false;
        }
        if (other.getInverted() == null ^ this.getInverted() == null) {
            return false;
        }
        if (other.getInverted() != null && !other.getInverted().equals(this.getInverted())) {
            return false;
        }
        if (other.getHealthThreshold() == null ^ this.getHealthThreshold() == null) {
            return false;
        }
        if (other.getHealthThreshold() != null && !other.getHealthThreshold().equals(this.getHealthThreshold())) {
            return false;
        }
        if (other.getChildHealthChecks() == null ^ this.getChildHealthChecks() == null) {
            return false;
        }
        if (other.getChildHealthChecks() != null && !other.getChildHealthChecks().equals(this.getChildHealthChecks())) {
            return false;
        }
        if (other.getEnableSNI() == null ^ this.getEnableSNI() == null) {
            return false;
        }
        if (other.getEnableSNI() != null && !other.getEnableSNI().equals(this.getEnableSNI())) {
            return false;
        }
        if (other.getRegions() == null ^ this.getRegions() == null) {
            return false;
        }
        if (other.getRegions() != null && !other.getRegions().equals(this.getRegions())) {
            return false;
        }
        if (other.getAlarmIdentifier() == null ^ this.getAlarmIdentifier() == null) {
            return false;
        }
        if (other.getAlarmIdentifier() != null && !other.getAlarmIdentifier().equals(this.getAlarmIdentifier())) {
            return false;
        }
        if (other.getInsufficientDataHealthStatus() == null ^ this.getInsufficientDataHealthStatus() == null) {
            return false;
        }
        return other.getInsufficientDataHealthStatus() == null || other.getInsufficientDataHealthStatus().equals(this.getInsufficientDataHealthStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIPAddress() == null ? 0 : this.getIPAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getResourcePath() == null ? 0 : this.getResourcePath().hashCode());
        hashCode = 31 * hashCode + (this.getFullyQualifiedDomainName() == null ? 0 : this.getFullyQualifiedDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getSearchString() == null ? 0 : this.getSearchString().hashCode());
        hashCode = 31 * hashCode + (this.getRequestInterval() == null ? 0 : this.getRequestInterval().hashCode());
        hashCode = 31 * hashCode + (this.getFailureThreshold() == null ? 0 : this.getFailureThreshold().hashCode());
        hashCode = 31 * hashCode + (this.getMeasureLatency() == null ? 0 : this.getMeasureLatency().hashCode());
        hashCode = 31 * hashCode + (this.getInverted() == null ? 0 : this.getInverted().hashCode());
        hashCode = 31 * hashCode + (this.getHealthThreshold() == null ? 0 : this.getHealthThreshold().hashCode());
        hashCode = 31 * hashCode + (this.getChildHealthChecks() == null ? 0 : this.getChildHealthChecks().hashCode());
        hashCode = 31 * hashCode + (this.getEnableSNI() == null ? 0 : this.getEnableSNI().hashCode());
        hashCode = 31 * hashCode + (this.getRegions() == null ? 0 : this.getRegions().hashCode());
        hashCode = 31 * hashCode + (this.getAlarmIdentifier() == null ? 0 : this.getAlarmIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getInsufficientDataHealthStatus() == null ? 0 : this.getInsufficientDataHealthStatus().hashCode());
        return hashCode;
    }

    public HealthCheckConfig clone() {
        try {
            return (HealthCheckConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

