/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.StepSummary;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListStepsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<StepSummary> steps;
    private String marker;

    public List<StepSummary> getSteps() {
        if (this.steps == null) {
            this.steps = new SdkInternalList();
        }
        return this.steps;
    }

    public void setSteps(Collection<StepSummary> steps) {
        if (steps == null) {
            this.steps = null;
            return;
        }
        this.steps = new SdkInternalList<StepSummary>(steps);
    }

    public ListStepsResult withSteps(StepSummary ... steps) {
        if (this.steps == null) {
            this.setSteps(new SdkInternalList<StepSummary>(steps.length));
        }
        for (StepSummary ele : steps) {
            this.steps.add(ele);
        }
        return this;
    }

    public ListStepsResult withSteps(Collection<StepSummary> steps) {
        this.setSteps(steps);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListStepsResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSteps() != null) {
            sb.append("Steps: ").append(this.getSteps()).append(",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStepsResult)) {
            return false;
        }
        ListStepsResult other = (ListStepsResult)obj;
        if (other.getSteps() == null ^ this.getSteps() == null) {
            return false;
        }
        if (other.getSteps() != null && !other.getSteps().equals(this.getSteps())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSteps() == null ? 0 : this.getSteps().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public ListStepsResult clone() {
        try {
            return (ListStepsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

