/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelbuilding.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lexmodelbuilding.model.EnumerationValue;
import java.util.List;

@SdkInternalApi
public class EnumerationValueMarshaller {
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("value").build();
    private static final MarshallingInfo<List> SYNONYMS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("synonyms").build();
    private static final EnumerationValueMarshaller instance = new EnumerationValueMarshaller();

    public static EnumerationValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(EnumerationValue enumerationValue, ProtocolMarshaller protocolMarshaller) {
        if (enumerationValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(enumerationValue.getValue(), VALUE_BINDING);
            protocolMarshaller.marshall(enumerationValue.getSynonyms(), SYNONYMS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

