/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisfirehose.model.CreateDeliveryStreamRequest;
import com.amazonaws.services.kinesisfirehose.model.transform.ElasticsearchDestinationConfigurationJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.RedshiftDestinationConfigurationJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.S3DestinationConfigurationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateDeliveryStreamRequestMarshaller
implements Marshaller<Request<CreateDeliveryStreamRequest>, CreateDeliveryStreamRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateDeliveryStreamRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateDeliveryStreamRequest> marshall(CreateDeliveryStreamRequest createDeliveryStreamRequest) {
        if (createDeliveryStreamRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDeliveryStreamRequest> request = new DefaultRequest<CreateDeliveryStreamRequest>(createDeliveryStreamRequest, "AmazonKinesisFirehose");
        request.addHeader("X-Amz-Target", "Firehose_20150804.CreateDeliveryStream");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createDeliveryStreamRequest.getDeliveryStreamName() != null) {
                jsonGenerator.writeFieldName("DeliveryStreamName").writeValue(createDeliveryStreamRequest.getDeliveryStreamName());
            }
            if (createDeliveryStreamRequest.getS3DestinationConfiguration() != null) {
                jsonGenerator.writeFieldName("S3DestinationConfiguration");
                S3DestinationConfigurationJsonMarshaller.getInstance().marshall(createDeliveryStreamRequest.getS3DestinationConfiguration(), jsonGenerator);
            }
            if (createDeliveryStreamRequest.getRedshiftDestinationConfiguration() != null) {
                jsonGenerator.writeFieldName("RedshiftDestinationConfiguration");
                RedshiftDestinationConfigurationJsonMarshaller.getInstance().marshall(createDeliveryStreamRequest.getRedshiftDestinationConfiguration(), jsonGenerator);
            }
            if (createDeliveryStreamRequest.getElasticsearchDestinationConfiguration() != null) {
                jsonGenerator.writeFieldName("ElasticsearchDestinationConfiguration");
                ElasticsearchDestinationConfigurationJsonMarshaller.getInstance().marshall(createDeliveryStreamRequest.getElasticsearchDestinationConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

