/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.waf.model.ActivatedRule;
import com.amazonaws.services.waf.model.transform.WafActionJsonMarshaller;

public class ActivatedRuleJsonMarshaller {
    private static ActivatedRuleJsonMarshaller instance;

    public void marshall(ActivatedRule activatedRule, StructuredJsonGenerator jsonGenerator) {
        if (activatedRule == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (activatedRule.getPriority() != null) {
                jsonGenerator.writeFieldName("Priority").writeValue(activatedRule.getPriority());
            }
            if (activatedRule.getRuleId() != null) {
                jsonGenerator.writeFieldName("RuleId").writeValue(activatedRule.getRuleId());
            }
            if (activatedRule.getAction() != null) {
                jsonGenerator.writeFieldName("Action");
                WafActionJsonMarshaller.getInstance().marshall(activatedRule.getAction(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ActivatedRuleJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ActivatedRuleJsonMarshaller();
        }
        return instance;
    }
}

