/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeVpcClassicLinkRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeVpcClassicLinkRequestMarshaller
implements Marshaller<Request<DescribeVpcClassicLinkRequest>, DescribeVpcClassicLinkRequest> {
    @Override
    public Request<DescribeVpcClassicLinkRequest> marshall(DescribeVpcClassicLinkRequest describeVpcClassicLinkRequest) {
        SdkInternalList describeVpcClassicLinkRequestVpcIdsList;
        if (describeVpcClassicLinkRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeVpcClassicLinkRequest> request = new DefaultRequest<DescribeVpcClassicLinkRequest>(describeVpcClassicLinkRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeVpcClassicLink");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeVpcClassicLinkRequestFiltersList = (SdkInternalList)describeVpcClassicLinkRequest.getFilters();
        if (!describeVpcClassicLinkRequestFiltersList.isEmpty() || !describeVpcClassicLinkRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeVpcClassicLinkRequestFiltersListValue : describeVpcClassicLinkRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeVpcClassicLinkRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeVpcClassicLinkRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeVpcClassicLinkRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeVpcClassicLinkRequestVpcIdsList = (SdkInternalList)describeVpcClassicLinkRequest.getVpcIds()).isEmpty() || !describeVpcClassicLinkRequestVpcIdsList.isAutoConstruct()) {
            int vpcIdsListIndex = 1;
            for (String describeVpcClassicLinkRequestVpcIdsListValue : describeVpcClassicLinkRequestVpcIdsList) {
                if (describeVpcClassicLinkRequestVpcIdsListValue != null) {
                    request.addParameter("VpcId." + vpcIdsListIndex, StringUtils.fromString(describeVpcClassicLinkRequestVpcIdsListValue));
                }
                ++vpcIdsListIndex;
            }
        }
        return request;
    }
}

