/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics.internal.cloudwatch;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.MetricCollector;
import com.amazonaws.metrics.internal.cloudwatch.CloudWatchMetricConfig;
import com.amazonaws.metrics.internal.cloudwatch.MetricCollectorSupport;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;

public class DefaultMetricCollectorFactory
implements MetricCollector.Factory {
    @Override
    public MetricCollector getInstance() {
        AWSCredentialsProvider provider = AwsSdkMetrics.getCredentialProvider();
        Region region = RegionUtils.getRegion(AwsSdkMetrics.getRegionName());
        Integer qSize = AwsSdkMetrics.getMetricQueueSize();
        Long timeoutMilli = AwsSdkMetrics.getQueuePollTimeoutMilli();
        CloudWatchMetricConfig config = new CloudWatchMetricConfig();
        ClientConfiguration clientConfig = new ClientConfiguration();
        if (provider != null) {
            config.setCredentialsProvider(provider);
        }
        if (region != null) {
            String endPoint = region.getServiceEndpoint("monitoring");
            config.setCloudWatchEndPoint(endPoint);
        }
        if (qSize != null) {
            config.setMetricQueueSize(qSize);
        }
        if (timeoutMilli != null) {
            config.setQueuePollTimeoutMilli(timeoutMilli);
        }
        config.setClientConfiguration(clientConfig);
        MetricCollectorSupport.startSingleton(config);
        return MetricCollectorSupport.getInstance();
    }
}

